<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FileTag extends Model
{
    use HasFactory;

    protected $with = ['file'];

    protected $appends = ['url'];

    public function file()
    {
        return $this->belongsTo('App\Models\File');
    }

    public function getUrlAttribute()
    {
        return $this->file->url;
    }
}
