<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $sharedDataList->name }} - Shared Data</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/vuetify@2.6.14/dist/vuetify.min.css" rel="stylesheet">
    @if (config('pianola-laravel.has_font_file'))
        <link href="{{ asset('fonts/font.css') }}" rel="stylesheet">
    @else
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900">
    @endif
    <!-- Removed XLSX script as Excel export is not available in calendar view -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: white;
            height: 100vh;
            overflow: hidden; /* Prevent body scrolling */
        }

        #app {
            height: 100vh;
            overflow: hidden;
        }

        .v-application {
            height: 100vh !important;
            overflow: hidden !important;
        }

        .navbar {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            padding: 1rem 2rem 1rem 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .navbar-content {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }

        .navbar-title {
            font-size: 1.5rem;
            font-weight: bold;
        }

        .navbar-subtitle {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .navbar-logo {
            height: 40px;
            width: auto;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .user-dropdown {
            position: relative;
            display: inline-block;
            border: 1px solid #999;
            border-radius: 4px;
            padding: 0.375rem 0.5rem;
        }

        .user-name {
            font-weight: 400;
            color: #ddd;
            font-size: 0.85rem;
            cursor: pointer;
            transition: background-color 0.2s;
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        .user-dropdown:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .user-icon {
            width: 16px;
            height: 16px;
            fill: #ddd;
        }

        .dropdown-arrow {
            font-size: 0.6rem;
            margin-left: 0.15rem;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            top: calc(100% + 0.5rem);
            background-color: white;
            border: 1px solid white;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            min-width: 120px;
            z-index: 1000;
        }

        .dropdown-content.show {
            display: block;
        }

        .dropdown-item {
            color: #333;
            padding: 0.75rem 1rem;
            text-decoration: none;
            display: block;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .dropdown-item:hover {
            background-color: #f8f9fa;
        }

        .back-btn {
            color: white !important;
            text-decoration: none;
            font-size: 0.9rem;
            transition: color 0.2s;
        }

        .v-event-timed {
            overflow: hidden !important;
        }

        .back-btn:hover {
            color: #ccc;
            text-decoration: underline;
        }

        .main-content {
            padding: 0;
            width: 100%;
            height: calc(100vh - 86px); /* Full height minus navbar */
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #ddd;
            font-size: 0.9rem;
        }

        .data-table th,
        .data-table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        .data-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #333;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .data-table tr:hover {
            background-color: #f8f9fa;
        }

        .no-data {
            text-align: center;
            color: #666;
            font-style: italic;
            padding: 3rem;
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 1rem;
            background-color: #f8f9fa;
            border-bottom: 1px solid #ddd;
            flex-shrink: 0; /* Don't shrink the header */
        }

        /* Removed search-related CSS as search functionality is not needed in calendar view */

        .action-buttons {
            display: flex;
            gap: 0.5rem;
            margin-left: 1rem;
        }

        .btn {
            padding: 0.5rem 1rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: white;
            color: #333;
            text-decoration: none;
            font-size: 0.9rem;
            cursor: pointer;
            transition: all 0.2s;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn:hover {
            background-color: #f8f9fa;
            border-color: #007cba;
            color: #007cba;
        }

        .btn-icon {
            width: 16px;
            height: 16px;
            fill: currentColor;
        }

        .calendar-placeholder {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 4rem 2rem;
            text-align: center;
            color: #666;
        }

        .calendar-icon {
            width: 64px;
            height: 64px;
            fill: #ccc;
            margin-bottom: 1rem;
        }

        .calendar-placeholder h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            color: #333;
        }

        .calendar-placeholder p {
            font-size: 1rem;
            color: #666;
        }

        .calendar-data-preview {
            margin-top: 2rem;
            text-align: left;
            max-width: 600px;
        }

        .calendar-data-preview h4 {
            margin-bottom: 1rem;
            color: #333;
        }

        .json-preview {
            background-color: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 4px;
            padding: 1rem;
            font-family: 'Courier New', monospace;
            font-size: 0.85rem;
            overflow-x: auto;
            white-space: pre-wrap;
            max-height: 400px;
            overflow-y: auto;
        }

        /* Calendar-specific styles from CalendarPrintoutController */
        .calendar-container {
            flex: 1; /* Take up remaining space */
            width: 100%;
            overflow: hidden;
            min-height: 0; /* Allow flex item to shrink */
        }

        .v-calendar-daily__day {
            margin-right: -2px;
            border-right: 0;
            border-bottom: 0 !important;
        }

        .v-calendar-daily__intervals-head:after {
            display: none;
        }

        .v-calendar-daily__intervals-head {
            border-bottom: 1px solid #e0e0e0;
        }

        .v-calendar-daily__interval-text {
            font-size: 12px;
        }

        .v-calendar-daily_head-day {
            margin-right: -1px !important;
            border-right: 0 !important;
        }

        .v-calendar-daily_head-day-label .v-btn {
            height: 30px;
            width: 30px;
        }

        .v-calendar-daily_head-weekday, .v-calendar-daily_head-day-label {
            color: black !important;
        }

        .v-calendar-category__column-header {
            min-height: 30px;
            padding-top: 4px;
        }

        /* Target the event block's border directly */
        .theme--light.v-calendar-events .v-event-timed {
            border: 0.25px solid white !important;
            padding: 2px !important;
        }

        .v-event-timed-container {
            margin-right: 0 !important;
        }

        .v-calendar-daily__scroll-area, .v-calendar-daily__pane {
            overflow: auto !important;
        }

        .pianola-day-calendar .v-calendar-daily_head-weekday,
        .pianola-day-calendar .v-calendar-daily_head-day-label {
            display: none;
        }

        .pianola-day-calendar .v-calendar-category__column-header {
            min-height: 30px;
            padding-top: 4px;
        }

        /* Calendar navigation styles */
        .calendar-navigation {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex: 1;
        }

        .calendar-type-toggle {
            display: flex;
            gap: 0.25rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            overflow: hidden;
        }

        .calendar-type-btn {
            border: none !important;
            border-radius: 0 !important;
            margin: 0 !important;
            background-color: white;
            transition: all 0.2s;
        }

        .calendar-type-btn.active {
            /* Active styling is handled by inline styles with dynamic primary color */
        }

        .calendar-type-btn:hover:not(.active) {
            background-color: #f8f9fa;
        }

        .date-navigation {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            flex: 1;
            max-width: 500px;
        }

        .date-select {
            flex: 1;
            padding: 0.5rem 1rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 0.9rem;
            background-color: white;
        }

        .date-select:focus {
            outline: none;
            border-color: #007cba;
            box-shadow: 0 0 0 2px rgba(0, 124, 186, 0.1);
        }

        .nav-arrow {
            padding: 0.5rem !important;
            min-width: 40px;
            justify-content: center;
        }

        .nav-arrow:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background-color: #f8f9fa !important;
            color: #999 !important;
        }

        .nav-arrow:disabled:hover {
            background-color: #f8f9fa !important;
            border-color: #ddd !important;
            color: #999 !important;
        }

        /* Week calendar styles */
        .pianola-week-calendar {
            border-bottom: 1px solid #e0e0e0;
            border-right: 1px solid #e0e0e0;
        }

        .pianola-week-calendar .v-calendar-daily__day {
            margin-right: -2px;
            border-right: 0;
            border-bottom: 0 !important;
        }

        /* Custom tooltip styles */
        .custom-tooltip {
            position: fixed;
            background-color: rgba(60, 60, 60, 0.9);
            color: white;
            padding: 4px 8px;
            border-radius: 3px;
            font-size: 11px;
            max-width: 300px;
            z-index: 10000;
            pointer-events: none;
            white-space: pre-wrap;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.2);
            line-height: 1.2;
            opacity: 0;
            transition: opacity 0.2s ease-in-out;
        }

        .custom-tooltip.show {
            opacity: 1;
        }

        .custom-tooltip .tooltip-title {
            font-weight: bold;
            margin: 0;
            padding: 0;
            display: inline;
        }

        .custom-tooltip .tooltip-content {
            margin: 0;
            padding: 0;
            display: inline;
        }


    </style>
</head>
<body>
    <div id="app">
        <v-app>
            <nav class="navbar">
                <div class="navbar-brand">
                    @if($appConfig['logoPath'])
                        <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="navbar-logo">
                    @endif
                    <div class="navbar-content">
                        <div class="navbar-title">{{ $sharedDataList->name }}</div>
                        @if($recordCount > 0)
                            <div class="navbar-subtitle">
                                {{ trans_choice('pianola-laravel::shared-data.showing_records', $recordCount, ['count' => number_format($recordCount)]) }} {{ __('pianola-laravel::shared-data.from_table', ['table' => $sharedDataList->base_table]) }}
                            </div>
                        @endif
                    </div>
                </div>
                <div class="navbar-user">
                    <a href="{{ route('shared-data.index') }}" class="back-btn">{{ __('pianola-laravel::shared-data.back_to_lists') }}</a>
                    <div class="user-dropdown" onclick="toggleDropdown()">
                        <span class="user-name">
                            <svg class="user-icon" viewBox="0 0 24 24">
                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                            </svg>
                            {{ $user->name }}
                            <span class="dropdown-arrow">▼</span>
                        </span>
                        <div class="dropdown-content" id="userDropdown">
                            <a class="dropdown-item" onclick="logout()">{{ __('pianola-laravel::shared-data.logout') }}</a>
                        </div>
                    </div>
                </div>
            </nav>

            <main class="main-content">
                @if($recordCount > 0)
                    <div class="table-header">
                        <div class="calendar-navigation">
                            <!-- Calendar Type Toggle -->
                            <div class="calendar-type-toggle" v-if="calendarData && calendarData.length > 0">
                                <button
                                    class="btn calendar-type-btn"
                                    :class="{ active: calendarType === 'day' }"
                                    :style="{ backgroundColor: calendarType === 'day' ? appConfig.colorPrimary : '', color: calendarType === 'day' ? 'white' : '' }"
                                    @click="setCalendarType('day')"
                                    :title="translations.dayView">
                                    <svg class="btn-icon" viewBox="0 0 24 24">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2" fill="none" stroke="currentColor" stroke-width="2"/>
                                        <line x1="16" y1="2" x2="16" y2="6" stroke="currentColor" stroke-width="2"/>
                                        <line x1="8" y1="2" x2="8" y2="6" stroke="currentColor" stroke-width="2"/>
                                        <line x1="3" y1="10" x2="21" y2="10" stroke="currentColor" stroke-width="2"/>
                                        <circle cx="12" cy="15" r="2" fill="currentColor"/>
                                    </svg>
                                </button>
                                <button
                                    class="btn calendar-type-btn"
                                    :class="{ active: calendarType === 'week' }"
                                    :style="{ backgroundColor: calendarType === 'week' ? appConfig.colorPrimary : '', color: calendarType === 'week' ? 'white' : '' }"
                                    @click="setCalendarType('week')"
                                    :title="translations.weekView">
                                    <svg class="btn-icon" viewBox="0 0 24 24">
                                        <path d="M19,3H18V1H16V3H8V1H6V3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3M19,19H5V8H19V19M5,6V5H19V6H5Z"/>
                                        <path d="M7,10H17V12H7V10M7,14H17V16H7V14Z"/>
                                    </svg>
                                </button>
                            </div>

                            <!-- Date/Week Navigation -->
                            <div class="date-navigation" v-if="calendarData && calendarData.length > 0">
                                <button
                                    class="btn nav-arrow"
                                    @click="navigatePrevious"
                                    :disabled="!canNavigatePrevious"
                                    v-if="canNavigatePrevious">
                                    <svg class="btn-icon" viewBox="0 0 24 24">
                                        <path d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z"/>
                                    </svg>
                                </button>

                                <select class="date-select" v-model="selectedPeriod" @change="onPeriodChange">
                                    <option value="">@{{ getSelectPlaceholder() }}</option>
                                    <option v-for="period in availablePeriods" :key="period.value" :value="period.value">
                                        @{{ period.label }}
                                    </option>
                                </select>

                                <button
                                    class="btn nav-arrow"
                                    @click="navigateNext"
                                    :disabled="!canNavigateNext"
                                    v-if="canNavigateNext">
                                    <svg class="btn-icon" viewBox="0 0 24 24">
                                        <path d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <div class="action-buttons">
                            <button class="btn" @click="printCalendar" v-if="calendarData && calendarData.length > 0">
                                <svg class="btn-icon" viewBox="0 0 24 24">
                                    <path d="M18,3H6V7H18M19,12A1,1 0 0,1 18,11A1,1 0 0,1 19,10A1,1 0 0,1 20,11A1,1 0 0,1 19,12M16,19H8V14H16M19,8H5A3,3 0 0,0 2,11V17H6V21H18V17H22V11A3,3 0 0,0 19,8Z"/>
                                </svg>
                                {{ __('pianola-laravel::shared-data.print_calendar') }}
                            </button>
                            <button class="btn" @click="printAllPeriods" v-if="calendarData && calendarData.length > 0">
                                <svg class="btn-icon" viewBox="0 0 24 24">
                                    <path d="M18,3H6V7H18M19,12A1,1 0 0,1 18,11A1,1 0 0,1 19,10A1,1 0 0,1 20,11A1,1 0 0,1 19,12M16,19H8V14H16M19,8H5A3,3 0 0,0 2,11V17H6V21H18V17H22V11A3,3 0 0,0 19,8Z M14,17H10V15H14V17Z"/>
                                </svg>
                                @{{ getPrintAllButtonText() }}
                            </button>
                            <button class="btn" onclick="window.location.href='{{ route('shared-data.show', $sharedDataList->id) }}'">
                                <svg class="btn-icon" viewBox="0 0 24 24">
                                    <path d="M3,3H21A1,1 0 0,1 22,4V20A1,1 0 0,1 21,21H3A1,1 0 0,1 2,20V4A1,1 0 0,1 3,3M4,5V7H8V5H4M10,5V7H14V5H10M16,5V7H20V5H16M4,9V11H8V9H4M10,9V11H14V9H10M16,9V11H20V9H16M4,13V15H8V13H4M10,13V15H14V13H10M16,13V15H20V13H16M4,17V19H8V17H4M10,17V19H14V17H10M16,17V19H20V17H16Z"/>
                                </svg>
                                {{ __('pianola-laravel::shared-data.list_view') }}
                            </button>
                        </div>
                    </div>

                    <div class="calendar-container">
                        @if(!empty($calendarData))
                            <!-- Day Calendar -->
                            <v-calendar
                                v-if="calendarType === 'day' && selectedDate"
                                ref="dayCalendar"
                                :value="selectedDate"
                                :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                                type="category"
                                :locale="dateLocale"
                                interval-count="18"
                                interval-height="60"
                                :categories="categories"
                                :category-hide-dynamic="true"
                                :category-show-all="true"
                                first-time="08:00"
                                :events="parsedEvents"
                                event-overlap-mode="column"
                                light
                                class="pianola-day-calendar"
                                :event-overlap-threshold="10"
                                :event-color="getEventColor"
                                :event-text-color="getEventTextColor"
                                @click:event="showEvent"
                            >
                                <template v-slot:category="{category}">
                                    <div v-html="formattedCategory(category)" style="text-align: center;"></div>
                                </template>
                                <template v-slot:event="{ event }">
                                    <div
                                        style="margin: 2px; overflow: hidden; cursor: pointer; position: relative;"
                                        @mouseenter="showTooltip($event, event)"
                                        @mouseleave="hideTooltip"
                                        @mousemove="moveTooltip($event)"
                                    >
                                        <div style="margin-top: -2px; margin-bottom: 0;">
                                            <strong class="font-medium" v-html="event.name"
                                                    style="font-size: 11px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                                        </div>
                                        <div
                                            style="white-space: pre-wrap; width: 100%; font-size: 10px;"
                                            v-html="event.moreInformation"
                                        ></div>
                                    </div>
                                </template>
                            </v-calendar>

                            <!-- Week Calendar -->
                            <v-calendar
                                v-if="calendarType === 'week' && selectedDate"
                                ref="weekCalendar"
                                :value="weekCalendarDate"
                                :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                                type="week"
                                :locale="dateLocale"
                                interval-count="18"
                                interval-height="60"
                                first-time="08:00"
                                :events="weekParsedEvents"
                                event-overlap-mode="column"
                                light
                                class="pianola-week-calendar"
                                :event-overlap-threshold="10"
                                :event-color="getEventColor"
                                :event-text-color="getEventTextColor"
                                @click:event="showEvent"
                            >
                                <template v-slot:day-label-header="{date}">
                                    @{{ formatDateHeader(date) }}
                                </template>
                                <template v-slot:event="{ event }">
                                    <div
                                        style="margin: 2px; overflow: hidden; cursor: pointer; position: relative;"
                                        @mouseenter="showTooltip($event, event, true)"
                                        @mouseleave="hideTooltip"
                                        @mousemove="moveTooltip($event)"
                                    >
                                        <div style="margin-top: -2px; margin-bottom: 0;">
                                            <strong class="font-medium" v-html="event.name"
                                                    style="font-size: 10px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                                        </div>
                                        <div
                                            style="white-space: pre-wrap; width: 100%; font-size: 9px;"
                                            v-html="event.weekMoreInformation"
                                        ></div>
                                    </div>
                                </template>
                            </v-calendar>
                        @else
                            <div class="calendar-placeholder">
                                <svg class="calendar-icon" viewBox="0 0 24 24">
                                    <path d="M19,3H18V1H16V3H8V1H6V3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3M19,19H5V8H19V19M5,6V5H19V6H5Z"/>
                                </svg>
                                <h3>{{ __('pianola-laravel::shared-data.calendar_placeholder') }}</h3>
                                <p>No calendar mapping found for table: {{ $sharedDataList->pianolaQuery->base_table ?? 'unknown' }}</p>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="no-data">
                        {{ __('pianola-laravel::shared-data.no_data') }}
                    </div>
                @endif
            </main>
        </v-app>

        <!-- Custom tooltip -->
        <div
            id="customTooltip"
            class="custom-tooltip"
            style="display: none;"
        ></div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/vue@2.x/dist/vue.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vuetify@2.6.14/dist/vuetify.js"></script>
    <script>
        new Vue({
            el: '#app',
            vuetify: new Vuetify(),
            data() {
                const calendarData = @json($calendarData ?? []);
                return {
                    // Removed data and searchTerm as they're not needed for calendar view
                    columns: @json($columns),
                    calendarData: calendarData,
                    currentDate: null, // Will be set to first available date
                    selectedDate: null,
                    calendarType: 'day', // 'day' or 'week'
                    selectedPeriod: null, // For dropdown selection
                    isInitialized: false,
                    tooltipTimeout: null, // For tooltip delay
                    // Translated strings and app config
                    translations: {
                        selectDate: '{{ __('pianola-laravel::shared-data.select_date') }}',
                        selectWeek: 'Select Week',
                        dayView: '{{ __('pianola-laravel::shared-data.day_view') }}',
                        weekView: '{{ __('pianola-laravel::shared-data.week_view') }}'
                    },
                    appConfig: @json($appConfig)
                }
            },
            computed: {
                // Removed filteredData as search functionality is not needed in calendar view
                // Get all available dates sorted
                availableDates() {
                    if (this.calendarData.length === 0) return [];
                    const dates = [...new Set(this.calendarData.map(item => item.date))];
                    return dates.sort();
                },
                // Get first available date from calendar data
                firstAvailableDate() {
                    return this.availableDates.length > 0 ? this.availableDates[0] : null;
                },
                // Get available periods based on calendar type
                availablePeriods() {
                    if (!this.calendarType || this.availableDates.length === 0) return [];

                    if (this.calendarType === 'day') {
                        return this.availableDates.map(date => ({
                            value: date,
                            label: this.formatDateForDisplay(date)
                        }));
                    } else {
                        // Week view - group dates by week
                        const weeks = new Map();
                        this.availableDates.forEach(date => {
                            const weekStart = this.getWeekStart(date);
                            if (!weeks.has(weekStart)) {
                                weeks.set(weekStart, {
                                    value: date, // Use the original date, not the Monday
                                    weekStart: weekStart, // Store the Monday separately
                                    label: this.formatWeekForDisplay(weekStart),
                                    dates: []
                                });
                            }
                            weeks.get(weekStart).dates.push(date);
                        });
                        return Array.from(weeks.values()).sort((a, b) => a.weekStart.localeCompare(b.weekStart));
                    }
                },
                // Navigation helpers
                canNavigatePrevious() {
                    if (!this.selectedPeriod || !this.availablePeriods || this.availablePeriods.length === 0) return false;
                    const currentIndex = this.availablePeriods.findIndex(p => p.value === this.selectedPeriod);
                    return currentIndex > 0;
                },
                canNavigateNext() {
                    if (!this.selectedPeriod || !this.availablePeriods || this.availablePeriods.length === 0) return false;
                    const currentIndex = this.availablePeriods.findIndex(p => p.value === this.selectedPeriod);
                    return currentIndex < this.availablePeriods.length - 1;
                },
                // Get unique locations for categories (like CalendarPrintoutController) - for day view
                categories() {
                    if (!this.selectedDate || this.calendarType !== 'day') return [];
                    const eventsForDate = this.calendarData.filter(item => item.date === this.selectedDate);
                    const locations = [...new Set(eventsForDate.map(item => item.calendar_location))];
                    return locations.filter(loc => loc); // Remove empty locations
                },
                // Filter events for selected date (day view)
                eventsForSelectedDate() {
                    if (!this.selectedDate || this.calendarType !== 'day') return [];
                    return this.calendarData.filter(item => item.date === this.selectedDate);
                },
                // Filter events for selected week (week view)
                eventsForSelectedWeek() {
                    if (!this.selectedDate || this.calendarType !== 'week') return [];
                    const weekStart = this.getWeekStart(this.selectedDate);
                    const weekEnd = this.getWeekEnd(weekStart);
                    return this.calendarData.filter(item => {
                        return item.date >= weekStart && item.date <= weekEnd;
                    });
                },
                // Parsed events for day view
                parsedEvents() {
                    return this.eventsForSelectedDate.map((item) => {
                        return {
                            id: item.calendar_id,
                            locked: item.calendar_locked || false,
                            name: item.calendar_name || 'Untitled Event',
                            start: item.calendar_timestamp_start,
                            end: item.calendar_timestamp_end,
                            moreInformation: item.calendar_more_information || '',
                            category: item.calendar_location || 'No Location',
                            timed: true,
                            color: item.calendar_color || "grey",
                        };
                    });
                },
                // Parsed events for week view
                weekParsedEvents() {
                    return this.eventsForSelectedWeek.map((item) => {
                        return {
                            id: item.calendar_id,
                            locked: item.calendar_locked || false,
                            name: item.calendar_name || 'Untitled Event',
                            start: item.calendar_timestamp_start,
                            end: item.calendar_timestamp_end,
                            weekMoreInformation: item.calendar_location || '', // Show location in week view
                            timed: true,
                            color: item.calendar_color || "grey",
                        };
                    });
                },
                // Computed property for week calendar date
                weekCalendarDate() {
                    if (!this.selectedDate || this.calendarType !== 'week') return this.selectedDate;

                    // Find the selected period to get the weekStart
                    const selectedPeriod = this.availablePeriods.find(p => p.value === this.selectedPeriod);
                    if (selectedPeriod && selectedPeriod.weekStart) {
                        return selectedPeriod.weekStart;
                    }

                    // Fallback: calculate the Monday from selectedDate
                    return this.getWeekStart(this.selectedDate);
                },
                // Get the correct locale for date formatting
                dateLocale() {
                    // Map app language to JavaScript locale
                    const localeMap = {
                        'de': 'de-CH',
                        'en': 'en-US',
                        'fr': 'fr-CH',
                        'it': 'it-CH'
                    };
                    return localeMap[this.appConfig.appLanguage] || 'en-US';
                }
            },
            mounted() {
                // Initialize calendar data
                this.$nextTick(() => {
                    // Set the selected date to the first available date
                    this.selectedDate = this.firstAvailableDate;
                    this.selectedPeriod = this.firstAvailableDate;
                    this.isInitialized = true;
                });
            },
            methods: {
                // Removed getFieldValue method as it's not needed for calendar view

                // Removed exportToExcel method as it's not needed in calendar view
                // Users can switch to list view for Excel export functionality

                // Calendar-specific methods (from CalendarPrintoutController)
                showEvent(event) {
                    // Handle event click - could show details in a modal
                    console.log('Event clicked:', event);
                },
                viewDay(date) {
                    // Handle day click - could navigate to day view
                    console.log('Day clicked:', date);
                },
                getEventColor(event) {
                    return event.color;
                },
                getEventTextColor(event) {
                    if (this.getColorBrightness(event.color) === "dark") {
                        return "#fff";
                    } else {
                        return "#222";
                    }
                },
                getColorBrightness(color) {
                    // Remove the "#" character from the beginning (if present)
                    color = color.replace("#", "");
                    // Parse the color components
                    const r = parseInt(color.substr(0, 2), 16);
                    const g = parseInt(color.substr(2, 2), 16);
                    const b = parseInt(color.substr(4, 2), 16);
                    // Calculate the relative luminance
                    const luminance = (0.2126 * r + 0.7152 * g + 0.0722 * b) / 255;
                    // Determine the brightness based on the luminance
                    return luminance < 0.5 ? "dark" : "light";
                },
                formattedCategory(category) {
                    if (category.includes('<br/>')) {
                        const parts = category.split('<br/>');
                        return `<div style="font-size: 12px;">${parts[0]}</div><div style="font-size: 10px; margin-bottom: 4px;">${parts[1]}</div>`;
                    } else {
                        return `<div style="font-size: 12px; margin-bottom: 4px;">${category}</div>`;
                    }
                },
                formatDateForDisplay(dateString) {
                    // Convert YYYY-MM-DD to a more readable format
                    const date = new Date(dateString + 'T00:00:00'); // Add time to avoid timezone issues
                    const options = {
                        weekday: 'long',
                        year: 'numeric',
                        month: 'long',
                        day: 'numeric'
                    };
                    return date.toLocaleDateString(this.dateLocale, options);
                },
                onDateChange() {
                    // This method is called when the date dropdown changes
                    // The calendar will automatically update due to reactive data
                    // No server round trip needed
                },
                // Calendar type and navigation methods
                setCalendarType(type) {
                    this.calendarType = type;
                    // Reset to first available period when switching types
                    if (this.availablePeriods.length > 0) {
                        this.selectedPeriod = this.availablePeriods[0].value;
                        this.selectedDate = this.availablePeriods[0].value;
                    }
                },
                onPeriodChange() {
                    this.selectedDate = this.selectedPeriod;
                },
                navigatePrevious() {
                    if (!this.canNavigatePrevious) return;
                    const currentIndex = this.availablePeriods.findIndex(p => p.value === this.selectedPeriod);
                    if (currentIndex > 0) {
                        this.selectedPeriod = this.availablePeriods[currentIndex - 1].value;
                        this.selectedDate = this.selectedPeriod;
                    }
                },
                navigateNext() {
                    if (!this.canNavigateNext) return;
                    const currentIndex = this.availablePeriods.findIndex(p => p.value === this.selectedPeriod);
                    if (currentIndex < this.availablePeriods.length - 1) {
                        this.selectedPeriod = this.availablePeriods[currentIndex + 1].value;
                        this.selectedDate = this.selectedPeriod;
                    }
                },
                // Week calculation helpers
                getWeekStart(dateString) {
                    // Use a more reliable approach to avoid timezone issues
                    const [year, month, day] = dateString.split('-').map(Number);
                    const date = new Date(year, month - 1, day); // month is 0-indexed
                    const dayOfWeek = date.getDay(); // 0 = Sunday, 1 = Monday, ..., 6 = Saturday

                    // Calculate how many days to go back to reach Monday
                    let daysBack;
                    if (dayOfWeek === 0) {
                        daysBack = 6; // Sunday: go back 6 days to Monday
                    } else if (dayOfWeek === 1) {
                        daysBack = 0; // Already Monday
                    } else {
                        daysBack = dayOfWeek - 1; // Tue(2)->1 day, Wed(3)->2 days, etc.
                    }

                    // Create the Monday date
                    const monday = new Date(year, month - 1, day - daysBack);

                    // Format as YYYY-MM-DD
                    const mondayYear = monday.getFullYear();
                    const mondayMonth = String(monday.getMonth() + 1).padStart(2, '0');
                    const mondayDay = String(monday.getDate()).padStart(2, '0');
                    const result = `${mondayYear}-${mondayMonth}-${mondayDay}`;

                    return result;
                },
                getWeekEnd(weekStart) {
                    const date = new Date(weekStart + 'T00:00:00');
                    const sunday = new Date(date.setDate(date.getDate() + 6));
                    return sunday.toISOString().split('T')[0];
                },
                formatWeekForDisplay(weekStart) {
                    const startDate = new Date(weekStart + 'T00:00:00'); // This is Monday
                    const endDate = new Date(weekStart + 'T00:00:00');
                    endDate.setDate(endDate.getDate() + 6); // This is Sunday

                    const startOptions = { day: 'numeric', month: 'short' };
                    const endOptions = { day: 'numeric', month: 'short', year: 'numeric' };

                    return `${startDate.toLocaleDateString(this.dateLocale, startOptions)} - ${endDate.toLocaleDateString(this.dateLocale, endOptions)}`;
                },
                formatDateHeader(dateString) {
                    const date = new Date(dateString);
                    return `${date.getDate()}.${date.getMonth() + 1}.${date.getFullYear()}`;
                },
                getSelectPlaceholder() {
                    return this.calendarType === 'day' ? this.translations.selectDate : this.translations.selectWeek;
                },

                // Custom tooltip methods
                showTooltip(mouseEvent, event, isWeekView = false) {
                    // Clear any existing timeout
                    if (this.tooltipTimeout) {
                        clearTimeout(this.tooltipTimeout);
                    }

                    // Set a delay before showing tooltip
                    this.tooltipTimeout = setTimeout(() => {
                        const tooltip = document.getElementById('customTooltip');
                        const title = event.name || 'Event';
                        const info = isWeekView ? (event.weekMoreInformation || '') : (event.moreInformation || '');

                        tooltip.innerHTML = `<span class="tooltip-title">${title}</span>${info ? `<br><span class="tooltip-content">${info}</span>` : ''}`;

                        tooltip.style.display = 'block';
                        this.moveTooltip(mouseEvent);

                        // Trigger fade-in effect
                        setTimeout(() => {
                            tooltip.classList.add('show');
                        }, 10); // Small delay to ensure display:block is applied first
                    }, 300); // 300ms delay
                },

                hideTooltip() {
                    // Clear timeout if tooltip hasn't shown yet
                    if (this.tooltipTimeout) {
                        clearTimeout(this.tooltipTimeout);
                        this.tooltipTimeout = null;
                    }

                    const tooltip = document.getElementById('customTooltip');
                    tooltip.classList.remove('show');

                    // Hide tooltip after fade-out completes
                    setTimeout(() => {
                        tooltip.style.display = 'none';
                    }, 200); // Match the CSS transition duration
                },

                moveTooltip(mouseEvent) {
                    const tooltip = document.getElementById('customTooltip');
                    if (tooltip.style.display === 'none') return;

                    // Position tooltip slightly below and to the right of cursor
                    tooltip.style.left = (mouseEvent.clientX + 10) + 'px';
                    tooltip.style.top = (mouseEvent.clientY + 10) + 'px';
                },

                // Print calendar functionality
                printCalendar() {
                    if (!this.selectedDate) {
                        alert('Please select a date first.');
                        return;
                    }

                    // Determine the type based on current calendar view
                    const type = this.calendarType === 'day' ? 'daily' : 'weekly';

                    // Build the print URL
                    const printUrl = new URL(window.location.href);
                    printUrl.searchParams.set('display', 'calendar_print');
                    printUrl.searchParams.set('type', type);
                    printUrl.searchParams.set('date', this.selectedDate);

                    // Open in new window for printing
                    window.open(printUrl.toString(), '_blank', 'width=1200,height=800');
                },

                // Print all periods functionality
                printAllPeriods() {
                    if (!this.availablePeriods || this.availablePeriods.length === 0) {
                        alert('No calendar data available for printing.');
                        return;
                    }

                    // Determine the type based on current calendar view
                    const type = this.calendarType === 'day' ? 'daily' : 'weekly';

                    // Build the print URL for all periods
                    const printUrl = new URL(window.location.href);
                    printUrl.searchParams.set('display', 'calendar_print_all');
                    printUrl.searchParams.set('type', type);

                    // Open in new window for printing
                    window.open(printUrl.toString(), '_blank', 'width=1200,height=800');
                },

                // Get text for print all button
                getPrintAllButtonText() {
                    if (this.calendarType === 'day') {
                        return '{{ __('pianola-laravel::shared-data.print_all_days') }}';
                    } else {
                        return '{{ __('pianola-laravel::shared-data.print_all_weeks') }}';
                    }
                }
            }
        });

        // Dropdown functionality (outside Vue app)
        function toggleDropdown() {
            const dropdown = document.getElementById('userDropdown');
            dropdown.classList.toggle('show');
        }

        // Close dropdown when clicking outside
        window.onclick = function(event) {
            if (!event.target.matches('.user-name')) {
                const dropdown = document.getElementById('userDropdown');
                if (dropdown.classList.contains('show')) {
                    dropdown.classList.remove('show');
                }
            }
        }

        async function logout() {
            try {
                const response = await fetch('{{ route("shared-data.logout") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                });

                if (response.ok) {
                    window.location.href = '{{ route("shared-data.login") }}';
                } else {
                    alert('Logout failed. Please try again.');
                }
            } catch (error) {
                alert('An error occurred during logout. Please try again.');
            }
        }
    </script>
</body>
</html>
