<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\SharedDataAuthController;
use BalletMecanique\PianolaLaravel\Http\Controllers\SharedDataController;
use BalletMecanique\PianolaLaravel\Http\Middleware\SharedDataApiKeyMiddleware;
use BalletMecanique\PianolaLaravel\Http\Middleware\SharedDataAuthMiddleware;
use Illuminate\Support\Facades\Route;

// Authentication routes (no middleware required)
Route::group(['prefix' => 'auth'], function () {
    // Registration routes
    Route::get('register', [SharedDataAuthController::class, 'showRegistrationForm'])->name('shared-data.register');
    Route::post('register', [SharedDataAuthController::class, 'register'])->name('shared-data.register.post');

    // Login routes
    Route::get('login', [SharedDataAuthController::class, 'showLoginForm'])->name('shared-data.login');
    Route::post('login', [SharedDataAuthController::class, 'login'])->name('shared-data.login.post');

    // Logout route
    Route::post('logout', [SharedDataAuthController::class, 'logout'])->name('shared-data.logout');

    // Current user route
    Route::get('user', [SharedDataAuthController::class, 'user'])->name('shared-data.user');
});
// Protected routes (require authentication or unlock token)
Route::middleware([SharedDataAuthMiddleware::class])->group(function () {
    // Data routes
    Route::get('/', [SharedDataController::class, 'index'])->name('shared-data.index');
    Route::get('/{id}', [SharedDataController::class, 'show'])->name('shared-data.show');
});

// API routes (require API key authentication)
Route::middleware([SharedDataApiKeyMiddleware::class])->group(function () {
    Route::get('/api/{id}', [SharedDataController::class, 'api'])->name('shared-data.api');
});

// API key management routes (require authentication)
Route::middleware([SharedDataAuthMiddleware::class])->group(function () {
    Route::post('/{id}/generate-api-key', [SharedDataController::class, 'generateApiKey'])->name('shared-data.generate-api-key');
    Route::get('/{id}/api-management', [SharedDataController::class, 'apiManagement'])->name('shared-data.api-management');
});

// Utility routes (for generating unlock tokens - you might want to protect these differently)
Route::post('generate-unlock-token', [SharedDataController::class, 'generateUnlockToken'])->name('shared-data.generate-token');
