<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaDocumentTemplate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;

class DocumentTemplateController
{
    public function index($endpoint, Request $request)
    {
        return PianolaDocumentTemplate::where('endpoint', $endpoint)->get();
    }

    public function store(Request $request)
    {
        return PianolaDocumentTemplate::create($request->input());
    }

    public function destroy($template_id)
    {
        $record = PianolaDocumentTemplate::destroy($template_id);

        return $template_id;
    }

    public function download($template_id)
    {
        $template = PianolaDocumentTemplate::find($template_id);
        $file_uuid = $template->file_uuid;
        $file_name = $template->file->name;
        $templatePath = 'templates/'.$file_uuid.'/'.$file_name;
        $templateFile = Storage::disk('s3')->get($templatePath);
        $headers = [
            'X-Vapor-Base64-Encode' => 'True',
            'Content-type' => 'text/docx',
            'Content-Disposition' => 'attachment; filename="'.$file_name.'"',
        ];

        return Response::make($templateFile, 200, $headers);
    }
}
