<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Database\Eloquent\Model;

class SharedDataListMember extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'pianola_shared_data_list_members';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'pianola_shared_data_list_id',
        'email',
    ];

    /**
     * Get the shared data list that owns this member.
     */
    public function sharedDataList()
    {
        return $this->belongsTo(SharedDataList::class, 'pianola_shared_data_list_id');
    }
}
