<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('pianola-laravel::shared-data.register_button') }} - {{ $appConfig['appName'] }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            @if($appConfig['backgroundPath'])
                background-image: url('{{ $appConfig['backgroundPath'] }}');
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-attachment: fixed;
            @else
                background-color: #f5f5f5;
            @endif
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo {
            height: 60px;
            width: auto;
            margin-bottom: 1rem;
        }

        .app-title {
            color: {{ $appConfig['colorPrimary'] }};
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }

        .register-title {
            color: #333;
            font-size: 1.2rem;
            margin: 0;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
        }

        input[type="text"], input[type="email"], input[type="password"] {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
            font-size: 1rem;
            transition: border-color 0.2s;
        }

        input[type="text"]:focus, input[type="email"]:focus, input[type="password"]:focus {
            outline: none;
            border-color: {{ $appConfig['colorPrimary'] }};
            box-shadow: 0 0 0 2px {{ $appConfig['colorPrimary'] }}20;
        }

        .register-btn {
            width: 100%;
            padding: 0.75rem;
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            transition: opacity 0.2s;
        }

        .register-btn:hover {
            opacity: 0.9;
        }

        .register-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .error {
            color: #dc3545;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .success {
            color: #28a745;
            font-size: 0.875rem;
            margin-top: 0.5rem;
            text-align: center;
        }

        .login-link {
            text-align: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid #eee;
        }

        .login-link a {
            color: {{ $appConfig['colorPrimary'] }};
            text-decoration: none;
            font-size: 0.9rem;
        }

        .login-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="header">
            @if($appConfig['logoPath'])
                <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="logo">
            @endif
            <div class="app-title">{{ $appConfig['appName'] }}</div>
            <h2 class="register-title">{{ __('pianola-laravel::shared-data.register_title') }}</h2>
        </div>

        <form id="registerForm">
            <div class="form-group">
                <label for="name">{{ __('pianola-laravel::shared-data.name') }}:</label>
                <input type="text" id="name" name="name" required>
                <div class="error" id="name-error"></div>
            </div>

            <div class="form-group">
                <label for="email">{{ __('pianola-laravel::shared-data.email') }}:</label>
                <input type="email" id="email" name="email" required>
                <div class="error" id="email-error"></div>
            </div>

            <div class="form-group">
                <label for="password">{{ __('pianola-laravel::shared-data.password') }}:</label>
                <input type="password" id="password" name="password" required>
                <div class="error" id="password-error"></div>
            </div>

            <div class="form-group">
                <label for="password_confirmation">{{ __('pianola-laravel::shared-data.confirm_password') }}:</label>
                <input type="password" id="password_confirmation" name="password_confirmation" required>
                <div class="error" id="password_confirmation-error"></div>
            </div>

            <button type="submit" class="register-btn">{{ __('pianola-laravel::shared-data.register_button') }}</button>
            <div class="success" id="success-message"></div>
            <div class="error" id="general-error"></div>
        </form>

        <div class="login-link">
            <a href="{{ route('shared-data.login') }}">{{ __('pianola-laravel::shared-data.already_have_account') }}</a>
        </div>
    </div>

    <script>
        document.getElementById('registerForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Clear previous errors
            document.querySelectorAll('.error').forEach(el => el.textContent = '');
            document.getElementById('success-message').textContent = '';
            
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);
            
            try {
                const response = await fetch('{{ route("shared-data.register.post") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    document.getElementById('success-message').textContent = '{{ __("pianola-laravel::shared-data.registration_successful") }}';
                    setTimeout(() => {
                        window.location.href = '{{ route("shared-data.index") }}';
                    }, 2000);
                } else {
                    if (result.errors) {
                        Object.keys(result.errors).forEach(field => {
                            const errorEl = document.getElementById(field + '-error');
                            if (errorEl) {
                                errorEl.textContent = result.errors[field][0];
                            }
                        });
                    } else {
                        document.getElementById('general-error').textContent = result.message || '{{ __("pianola-laravel::shared-data.registration_failed") }}';
                    }
                }
            } catch (error) {
                document.getElementById('general-error').textContent = '{{ __("pianola-laravel::shared-data.error_occurred") }}';
            }
        });
    </script>
</body>
</html>
