<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class SharedDataUser extends Authenticatable
{
    use Notifiable;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'pianola_shared_data_users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'api_key',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'api_key',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Generate a new API key for this user
     *
     * @return string
     */
    public function generateApiKey()
    {
        $apiKey = 'sd_' . bin2hex(random_bytes(32));
        $this->api_key = $apiKey;
        $this->save();

        return $apiKey;
    }

    /**
     * Regenerate the API key for this user
     *
     * @return string
     */
    public function regenerateApiKey()
    {
        return $this->generateApiKey();
    }

    /**
     * Check if the user has an API key
     *
     * @return bool
     */
    public function hasApiKey()
    {
        return !empty($this->api_key);
    }
}
