<?php

namespace BalletMecanique\PianolaLaravel\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AppendPianolaMessageToResponse
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Check if there's a pianola_message in the session
        if (session()->has('pianola_message')) {
            $message = session()->get('pianola_message');
            $messageTitle = session()->get('pianola_message_title');

            // If the response is JSON, add the message to it
            if ($response->headers->get('Content-Type') === 'application/json' ||
                str_contains($response->headers->get('Content-Type') ?? '', 'application/json')) {

                $content = json_decode($response->getContent(), true);

                if (is_array($content)) {
                    $content['pianola_message'] = $message;

                    if ($messageTitle) {
                        $content['pianola_message_title'] = $messageTitle;
                    }

                    $response->setContent(json_encode($content));
                }
            }
        }

        return $response;
    }
}

