<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController
{
    public function index()
    {
        return User::whereNull('is_dev')->orWhere('is_dev', '0')->get();
    }

    public function store(Request $request)
    {
        $data = $request->input();
        $user = new User;
        $user->password = Hash::make(env('DEFAULT_PASSWORD'));
        $user->email = $data['email'];
        $user->name = $data['name'];
        $user->modules = '[]';
        $user->is_active = 1;
        $user->reset_password = 1;
        $user->save();

        return $user;
    }

    public function update($id, Request $request)
    {
        $record = User::find($id);
        if ($record->exists()) {
            $data = $request->input('data');
            if (isset($data['is_active'])) {
                if ($data['is_active'] == true and $record['is_active'] == 0) {
                    $data['password'] = Hash::make(env('DEFAULT_PASSWORD'));
                }
                if ($data['is_active'] == false and $record['is_active'] == 1) {
                    $data['password'] = '';
                    $data['modules'] = null;
                }
            }
            $record->update($data);
        } else {
            return response('record does not exist', 404);
        }
    }

    public function show($id)
    {
        $submitter = Auth::user();
        $record = User::find($id);
        if (! $submitter->is_admin and $submitter->id != $id) {
            return response('forbidden', 403);
        }

        return $record;
    }

    public function destroy($id)
    {
        User::destroy($id);
    }

    public function returnUser(Request $request)
    {
        return $request->user();
    }

    public function changePassword(Request $request)
    {
        $password = $request->input('password');
        $user_id = Auth::user()->id;
        $user = User::find($user_id);
        $user->password = Hash::make($password);
        $user->reset_password = false;
        $user->save();

        return $user;
    }

    public function resetPassword($id)
    {
        $user = User::find($id);
        $user->password = Hash::make(env('DEFAULT_PASSWORD'));
        $user->reset_password = 1;
        $user->save();

        return $user;
    }

    public function reset2fa($id)
    {
        $user = User::find($id);
        $user->two_factor_secret = null;
        $user->two_factor_recovery_codes = null;
        $user->save();

        return $user;
    }
}
