<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_rights_rules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_user_group_id')->constrained()->cascadeOnDelete();
            $table->string('type')->nullable();
            $table->string('table_name')->nullable();
            $table->string('field_name')->nullable();
            $table->string('rights')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_rights_rules');
    }
};
