<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController
{
    public function index()
    {
        return User::whereNull('is_dev')->orWhere('is_dev', '0')->get();
    }

    public function store(Request $request)
    {
        $data = $request->input();
        $user = new User();
        $user->password = Hash::make(env('DEFAULT_PASSWORD'));
        $user->email = $data['email'];
        $user->name = $data['name'];
        $user->modules = "[]";
        $user->is_active = 1;
        $user->reset_password = 1;
        $user->save();

        return $user;
    }

    public function destroy($id)
    {
        User::destroy($id);
    }

    public function returnUser(Request $request)
    {
        return $request->user();
    }

    public function changePassword(Request $request)
    {
        $password = $request->input('password');
        $user_id = Auth::user()->id;
        $user = User::find($user_id);
        $user->password = Hash::make($password);
        $user->reset_password = false;
        $user->save();

        return $user;
    }
}
