<!DOCTYPE html>
<html>
<head>
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/vuetify@2.3.23/dist/vuetify.min.css" rel="stylesheet">
    @if (config('pianola.has_font_file'))
        <link href="{{ asset('fonts/font.css') }}" rel=stylesheet>
    @else
        <link rel=stylesheet href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900">
    @endif
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
    <style>

        body {
            font-size: 8px !important;
        }

        html, body, #app {
            width: 272mm;
        }

        .pianola-day-calendar, .pianola-week-calendar {
            border-bottom: 1px solid #e0e0e0;
            border-right: 1px solid #e0e0e0;
            margin: 5px 5px -6px;
        }

        .v-calendar-daily__day {
            margin-right: -2px;
            border-right: 0;
            border-bottom: 0 !important;
        }

        .v-calendar-daily__intervals-head:after {
            display: none;
        }

        .v-calendar-daily__intervals-head {
            border-bottom: 1px solid #e0e0e0;
        }

        .v-calendar-daily__interval-text {
            font-size: 8px;
        }

        .v-calendar-daily_head-day {
            margin-right: -1px !important;
            border-right: 0 !important;
        }

        .v-calendar-daily_head-day-label .v-btn {
            height: 30px;
            width: 30px;
        }

        .v-calendar-daily_head-weekday, .v-calendar-daily_head-day-label {
            color: black !important;
        }

        .pianola-day-calendar .v-calendar-daily_head-weekday,
        .pianola-day-calendar .v-calendar-daily_head-day-label {
            display: none;
        }

        .pianola-day-calendar .v-calendar-category__column-header {
            min-height: 30px;
            padding-top: 4px;
        }

        /* Target the event block's border directly */
        .theme--light.v-calendar-events .v-event-timed {
            border: 0.25px solid white !important;
            padding: 2px !important;
        }

        .v-event-timed-container {
            margin-right: 0 !important;
        }

        .v-calendar-daily__scroll-area, .v-calendar-daily__pane {
            overflow: hidden !important;
        }

        /*.frame {*/
        /*    width: 277mm;*/
        /*    height: 180mm;*/
        /*}*/

        .titleText {
            font-size: 16px !important;
            font-weight: 500;
            margin-left: 12px;
        }

        .header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            margin-left: 10px;
        }

        .logo {
            width: 25px;
        }
    </style>
    <title>{{$title}}</title>
</head>
<body>
<div id="app">
    <v-app>
        <div class="header">
            <img
                class="logo"
                src="{{$logoPath}}"
                alt="logo"/>
            <div class="titleText">{{ $title }}</div>
        </div>
        <div class="frame">
            <v-calendar
                v-if="type === 'daily'"
                ref="calendar"
                :value="date"
                :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                type="category"
                locale="de-CH"
                interval-count="16"
                interval-height="39"
                :categories="categories"
                :category-hide-dynamic="true"
                :category-show-all="true"
                first-time="08:00"
                :events="parsedEvents"
                event-overlap-mode="column"
                light
                class="pianola-day-calendar"
                :event-overlap-threshold="10"
                :event-color="getEventColor"
                :event-text-color="getEventTextColor"
            >
                <template v-slot:category="{category}">
                    <div v-html="formattedCategory(category)" style="text-align: center;"></div>
                </template>
                <template v-slot:event="{ event }">
                    <div style="margin: 2px; overflow: hidden;">
                        <div style="margin-top: -2px; margin-bottom: 0;">
                            <strong class="font-medium" v-html="event.name"
                                    style="font-size: 8px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                        </div>
                        <div
                            style="white-space: pre-wrap; width: 100%; font-size: 8px; "
                            v-html="event.moreInformation"
                        ></div>
                    </div>
                </template>
            </v-calendar>
            <v-calendar
                v-if="type === 'weekly'"
                ref="calendar"
                :value="date"
                :weekdays="[1, 2, 3, 4, 5, 6, 0]"
                type="week"
                locale="de-CH"
                interval-count="16"
                interval-height="38"
                :categories="categories"
                :category-hide-dynamic="true"
                :category-show-all="true"
                first-time="08:00"
                :events="filteredEvents"
                event-overlap-mode="column"
                light
                class="pianola-week-calendar"
                :event-overlap-threshold="10"
                :event-color="getEventColor"
                :event-text-color="getEventTextColor"
            >
                <template v-slot:day-label-header="{date}">
                    @{{formatDate(date)}}
                </template>
                <template v-slot:event="{ event }">
                    <div style="margin: 2px; overflow: hidden;">
                        <div style="margin-top: -2px; margin-bottom: 0;">
                            <strong class="font-medium" v-html="event.name"
                                    style="font-size: 8px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block;"></strong>
                        </div>
                        <div
                            style="white-space: pre-wrap; width: 100%; font-size: 8px; "
                            v-html="event.moreInformation"
                        ></div>
                    </div>
                </template>
            </v-calendar>
        </div>
    </v-app>
</div>

<script src="https://cdn.jsdelivr.net/npm/vue@2.x/dist/vue.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vuetify@2.3.23/dist/vuetify.js"></script>
<script>
    new Vue({
        el: '#app',
        vuetify: new Vuetify(),
        data() {
            return {
                categories: {!! json_encode($locations) !!},
                events: {!! json_encode($events) !!},
                date: {!! json_encode($date) !!},
                type: {!! json_encode($type) !!},
            }
        },
        computed: {
            filteredEvents() {
                return this.parsedEvents.filter((item) => {
                    return this.categories.includes(item.category);
                });
            },
            parsedEvents() {
                return this.events.map((item) => {
                    return {
                        id: item.calendar_id,
                        locked: item.calendar_locked || false,
                        name: item.calendar_name,
                        start: item.calendar_timestamp_start,
                        end: item.calendar_timestamp_end,
                        moreInformation: this.type === 'daily' ? item.calendar_more_information : item.calendar_location,
                        category: item.calendar_location,
                        timed: true,
                        color: item.calendar_color || "grey",
                    };
                });
            },
        },
        methods: {
            formattedCategory(category) {
                if (category.includes('<br/>')) {
                    const parts = category.split('<br/>');
                    return `<div style="font-size: 8px;">${parts[0]}</div><div style="font-size: 6px; margin-bottom: 4px;">${parts[1]}</div>`;
                } else {
                    return `<div style="font-size: 8px; margin-bottom: 4px;">${category}</div>`;
                }
            },
            formatDate(string) {
                //return dd.mm.yyyy
                const date = new Date(string);
                return `${date.getDate()}.${date.getMonth() + 1}.${date.getFullYear()}`;
            },
            getEventColor(event) {
                return event.color;
            },
            getEventTextColor(event) {
                if (this.getColorBrightness(event.color) === "dark") {
                    return "#fff";
                } else {
                    return "#222";
                }
            },
            rnd(a, b) {
                return Math.floor((b - a + 1) * Math.random()) + a;
            },
            getColorBrightness(color) {
                // Remove the "#" character from the beginning (if present)
                color = color.replace("#", "");
                // Parse the color components
                const r = parseInt(color.substr(0, 2), 16);
                const g = parseInt(color.substr(2, 2), 16);
                const b = parseInt(color.substr(4, 2), 16);
                // Calculate the relative luminance
                const luminance = (0.2126 * r + 0.7152 * g + 0.0722 * b) / 255;
                // Determine the brightness based on the luminance
                return luminance < 0.5 ? "dark" : "light";
            },
        }
    })
    // enter print mode on load
    //if dev mode local
    @if(config('app.env') !== 'local')
    setTimeout(function () {
        window.print();
    }, 10);
    window.onfocus = function () {
        setTimeout(function () {
            window.close();
        }, 10);
    }
    @endif
</script>
</body>
</html>
