<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_shared_data_list_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_shared_data_list_id')
                ->constrained('pianola_shared_data_lists')
                ->onDelete('cascade')
                ->name('fk_shared_data_list_members_list_id');
            $table->string('email')->index();
            $table->timestamps();

            // Ensure unique combination of list and email
            $table->unique(['pianola_shared_data_list_id', 'email'], 'unique_list_member');
        });
    }
};
