<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\SchemaUpdateService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class ConfigController
{
    public function getLoginConfig(): array
    {
        $config = $this->getFile('app.json');
        // $config = json_decode($configString, true);
        $newArray['basicConfig'] = $config['basicConfig'];
        $newArray['modules'][0]['basicConfig']['path'] = $config['modules'][0]['basicConfig']['path'];

        return $newArray;
    }

    public function getAppConfig()
    {
        $user = auth()->user();
        $config = $this->getFile('app.json');
        if (! $user) {
            return null;
        }
        $moduleRights = json_decode($user['modules'], true, 512, JSON_THROW_ON_ERROR);
        if (! $user['is_admin'] && collect($moduleRights)->count() > 0) {
            $modules = $config['modules'];
            $modules = collect($modules)->map(function ($module) use ($moduleRights) {
                $moduleName = $module['basicConfig']['name'];
                if (
                    isset($moduleRights[$moduleName])
                    &&
                    $moduleRights[$moduleName]
                    &&
                    $moduleRights[$moduleName] !== 'none'
                ) {
                    return $module;
                }

                return null;
            })->filter()->values();
            $config['modules'] = $modules;
        }

        return $config;
    }

    public function storeAppConfig(Request $request)
    {
        if (config('app.env') !== 'local') {
            return response()->json(['error' => 'Not authorized.'], 403);
        }

        $this->storeFile('app.json', $request->input('config'));

        return 'ok';
    }

    public function getSchemaConfig()
    {
        return $this->getFile('schema.json');
    }

    public function storeSchemaConfig(Request $request)
    {
        if (config('app.env') !== 'local') {
            return response()->json(['error' => 'Not authorized.'], 403);
        }

        $this->storeFile('schema.json', $request->input('config'));

        return 'ok';
    }

    public function updateSchema()
    {
        $service = new SchemaUpdateService;

        $updatedSchema = $service->updateSchema();

        $this->storeFile('schema.json', $updatedSchema);

        return $this->getFile('schema.json');
    }

    public function createModels(): string
    {
        return (new SchemaUpdateService)->createModels();
    }

    public function getDevMode()
    {
        return config('app.env');
    }

    protected function storeFile($filename, $configObject): void
    {
        File::put(config_path('/pianola/'.$filename), json_encode($configObject, JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    }

    protected function getFile($filename)
    {
        return json_decode(File::get(config_path('/pianola/'.$filename)), true, 512, JSON_THROW_ON_ERROR);
    }
}
