<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

class GlobalFilterController
{
    public function show(Request $request, $endpoint, $valueField, $labelField)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $model = new $modelName;
        $ids = $model::query()
            ->select($valueField)
            ->selectRaw('min(id) as min_id')
            ->whereNotNull($valueField)
            ->groupBy($valueField)
            ->get()
            ->pluck('min_id');
        $records = $model::query()
            ->whereIn('id', $ids)
            ->when($valueField === $labelField, function ($query) use ($labelField) {
                $query->orderByDesc($labelField);
            })
            ->get();
        $array = $records
            ->map(function ($record) use ($valueField, $labelField) {
                return [
                    'text' => $record[$labelField],
                    'value' => $record[$valueField],
                ];
            })
            ->toArray();
        if ($request->input('optionAll')) {
            $array[] = ['value' => null, 'text' => $request->input('optionAllLabel')];
        }
        $result['items'] = $array;
        $result['default'] = $array[0]['value'];

        return $result;
    }
}
