<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PianolaDocumentTemplate extends Model
{
    protected $guarded = [];

    protected $appends = ['generate', 'edit', 'type_display'];

    protected $with = ['file', 'user'];

    public function file(): BelongsTo
    {
        return $this->belongsTo('App\Models\File', 'file_uuid', 'uuid');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo('App\Models\User');
    }

    public function getGenerateAttribute(): string
    {
        return '';
    }

    public function getEditAttribute(): string
    {
        return '';
    }

    public function getTypeDisplayAttribute(): string
    {
        if ($this->type === 'single') {
            return 'einzelner Datensatz';
        }
        if ($this->type === 'multiple') {
            return 'alle aufgerufenen Datensätze';
        }

        return '';
    }
}
