<?php

namespace BalletMecanique\PianolaLaravel\Services;

use BalletMecanique\PianolaLaravel\Models\PianolaDocumentTemplate;
use DB;
use Http;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Response;
use Storage;

class DocumentMakerService
{
    public function uploadTemplate($file_uuid, $file_name): void
    {
        // retrieve file from S3
        $templatePath = 'templates/'.$file_uuid.'/'.$file_name;
        $templateFile = Storage::disk('s3')->get($templatePath);
        $attachment = base64_encode($templateFile);
        // post data to API with template as attachment
        Http::post(config('app.document_maker_url').'/api/store-template', compact('attachment', 'file_uuid'));
    }

    /**
     * @throws RequestException
     */
    public function processDocumentCreation($template_id, $data, $file_uuid = null, $file_name = null, $storage_path = null, $returnObject = 'downloadLink')
    {
        // check if data is array or object - convert to array
        $dataArray = is_array($data) ? $data : $data->toArray();
        $data = $this->applyHtmlSpecialCharsExceptHttp($dataArray);
        // determine file_uuid if passed as template id
        if ($template_id > 0) {
            $template = PianolaDocumentTemplate::find($template_id);
            $file_uuid = $template->file_uuid;
            $file_name = $template->file->name;
        }
        // post data to API with template uuid
        $endpoint = ($returnObject === 'downloadLink') ? 'queue-document' : 'create-document';
        $response = Http::post(config('app.document_maker_url').'/api/'.$endpoint, compact('data', 'file_uuid', 'storage_path'));
        if ($response == 'no template') {
            $this->uploadTemplate($file_uuid, $file_name);
            $response = Http::post(config('app.document_maker_url').'/api/'.$endpoint, compact('data', 'file_uuid', 'storage_path'));
        }

        if ($returnObject === 'downloadLink') {
            if ($response->successful()) {
                return $response;
            }

            return $response->throw();
        }

        $suffix = date('_Y_m_d_h_i');
        $filename = str_replace('.docx', $suffix.'.docx', $file_name);
        $headers = [
            'X-Vapor-Base64-Encode' => 'True',
            'Content-type' => 'text/docx',
            'Content-Disposition' => 'attachment; filename="'.$filename.'"',
        ];

        return Response::make($response, 200, $headers);
    }

    protected function applyHtmlSpecialCharsExceptHttp($data)
    {
        if (is_object($data)) {
            return $data;
        }
        if (is_array($data)) {
            foreach ($data as &$value) {
                $value = $this->applyHtmlSpecialCharsExceptHttp($value);
            }
            unset($value);
        } elseif (! str_contains($data, 'http') && ! str_contains($data, '<w:')) {
            $data = str_replace(['<', '>'], ['«', '»'], $data);
        }

        return $data;
    }

    public function queueDocumentForCreation($template_id, $data, $file_uuid = null, $file_name = null, $storage_path = null, $webhook_url = null): \Illuminate\Http\Client\Response
    {
        // determine file_uuid if passed as template id
        if ($template_id > 0) {
            $template = PianolaDocumentTemplate::find($template_id);
            $file_uuid = $template->file_uuid;
            $file_name = $template->file->name;
        }
        // post data to API with template uuid

        DB::disconnect('mysql');
        $response = Http::post(config('app.document_maker_url').'/api/queue-document', compact('data', 'file_uuid', 'storage_path', 'webhook_url'));
        if ($response == 'no template') {
            $this->uploadTemplate($file_uuid, $file_name);
            $response = Http::post(config('app.document_maker_url').'/api/queue-document', compact('data', 'file_uuid', 'storage_path', 'webhook_url'));
        }
        DB::reconnect('mysql');

        if ($response->successful()) {
            return $response;
        }

        return $response->throw();
    }
}
