<?php

namespace BalletMecanique\PianolaLaravel\Commands;

use BalletMecanique\PianolaLaravel\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class CreateDevUserCommand extends Command
{
    public $signature = 'pianola:create-dev-user';

    public $description = 'Creates a Dev User';

    public function handle(): int
    {
        //create new user with feedback
        $this->info('Create a local dev user for the app:');
        //name
        $gitName = trim(shell_exec('git config --get pianola.user-name'));
        if($gitName) {
            $name = $this->ask('What is your name?', $gitName);
        } else {
            $name = $this->ask('What is your name?');
        }
        while ($name === '') {
            $name = $this->ask('Name cannot be empty. What is your name?');
        }
        if(! $gitName) {
            shell_exec('git config --global pianola.user-name "' . $name . '"');
        }
        //email
        $gitEmail = trim(shell_exec('git config --get pianola.user-email'));
        if($gitEmail) {
            $email = $this->ask('What is your mail address? (user name)', $gitEmail);
        } else {
            $email = $this->ask('What is your mail address? (user name)');
        }
        while ($email === '') {
            $email = $this->ask('Email address cannot be empty. What is your mail address?');
        }
        if(! $gitEmail) {
            shell_exec('git config --global pianola.user-email "' . $email . '"');
        }
        $password = $this->ask('What initial password do you want to use?', 'password');

        User::updateOrCreate(
            [
                'email' => $email,
            ],
            [
                'name' => $name,
                'email' => $email,
                'password' => Hash::make($password),
                'is_dev' => 1,
                'is_admin' => 1,
                'is_active' => 1,
                'modules' => json_encode([]),
        ]
        );

        return self::SUCCESS;
    }
}
