<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Events\FormSubmitted;
use BalletMecanique\PianolaLaravel\Models\PianolaForm;
use BalletMecanique\PianolaLaravel\Models\PianolaFormSubmission;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Str;
use JsonException;

class FormController
{
    public function create()
    {
        return view('pianola-laravel::forms.create');
    }

    /**
     * @throws JsonException
     */
    public function getStyling(): array
    {
        $appJson = file_get_contents(config_path('pianola/app.json'));
        $app = json_decode($appJson, true, 512, JSON_THROW_ON_ERROR);

        return collect($app['basicConfig'])
            ->only('appName', 'appFont', 'logoPath', 'colorBackground', 'colorPrimary', 'bannerPath')
            ->toArray();
    }

    public function getFormElements($slug)
    {
        if(! $slug) {
            return [];
        }

        $form = PianolaForm::query()
            ->where('slug', $slug)
            ->with('formElements')
            ->firstOrFail();

        $elements = $form->formElements;
        $elements[] = [
            'element_type' => 'csrf_token',
            'name' => '_token',
            'value' => csrf_token(),
        ];

        return $elements;
    }

    /**
     * @throws JsonException
     */
    public function getFormData(string $submissionId): array
    {
        $formSubmission = PianolaFormSubmission::query()
            ->where('submission_id', $submissionId)
            ->firstOrFail();

        return json_decode($formSubmission->input, true, 512, JSON_THROW_ON_ERROR);
    }

    /**
     * @throws JsonException
     */
    public function store()
    {
        $input = request()?->input('data');
        $formType = request()?->input('formType');
        $submissionId = request()?->input('submissionId');
        $formSubmission = PianolaFormSubmission::where('submission_id', $submissionId)->first();
        if($formSubmission) {
            $formSubmission->update(['input' => $input]);
        } else {
            $formSubmission = PianolaFormSubmission::create([
                'submission_id' => Str::uuid(),
                'input' => json_encode($input, JSON_THROW_ON_ERROR),
                'form_type' => $formType,
            ]);
        }
        Event::dispatch(new FormSubmitted($formSubmission->id));

        return 'ok';
    }
}
