<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaCalendarPreset;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CalendarPresetController
{
    public function index(Request $request)
    {
        $base_table = $request->input('module');
        $presets = PianolaCalendarPreset::where('module', $base_table)->get();

        return $presets;
    }

    public function store(Request $request)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;
        $query = PianolaCalendarPreset::create($input);

        return $query;
    }

    public function show($id)
    {
        $query = PianolaCalendarPreset::find($id);

        return $query;
    }

    public function update(Request $request, $id)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;
        $query = PianolaCalendarPreset::find($id);
        $query->update($input);

        return $query;
    }

    public function destroy($id)
    {
        $query = PianolaCalendarPreset::destroy($id);

        return 'ok';
    }
}
