<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PianolaQuery extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $appends = ['user_name'];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function getUserNameAttribute()
    {
        return $this->user['name'];
    }
}
