<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class FileUploadController extends Controller
{
    public function store(Request $request)
    {
        $input = $request->input();
        $key = $input['key'];
        $path = env('pianola.filepath') ?? 'files';
        $key_new = $path.'/'.$input['uuid'].'/'.'original'.'/'.$input['name'];
        Storage::copy(
            $key,
            $key_new
        );

        $file = new \App\Models\File();
        $file->uuid = $input['uuid'];
        $file->filename = $input['name'];
        $file->mimetype = $input['content_type'];
        $file->path = $key_new;
        $file->width = $input['width'];
        $file->height = $input['height'];
        $file->save();

        $fileTag = new \App\Models\FileTag();
        $fileTag->file_id = $file->id;
        $fileTag->fileable_type = $input['endpoint'];
        $fileTag->fileable_id = $input['recordId'];
        $fileTag->save();
    }
}
