<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_form_elements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_form_id')->constrained()->cascadeOnDelete();
            $table->string('element_type');
            $table->text('label')->nullable();
            $table->text('caption')->nullable();
            $table->string('key_name')->nullable();
            $table->boolean('is_required')->default(false);
            $table->boolean('is_active')->default(true);
            $table->boolean('is_read_only')->default(false);
            $table->integer('sort_order')->nullable();
            $table->text('values')->nullable();
            $table->string('value_table')->nullable();
            $table->string('value_column')->nullable();
            $table->text('options')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_cms_table_content_elements');
    }
};
