<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_form_localisations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_form_element_id')->constrained()->cascadeOnDelete();
            $table->string('language');
            $table->text('label')->nullable();
            $table->text('caption')->nullable();
            $table->text('values')->nullable();
            $table->string('value_column')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_cms_table_content_elements');
    }
};
