<?php

namespace BalletMecanique\PianolaLaravel\Http\Middleware;

use BalletMecanique\PianolaLaravel\Services\PianolaUserState;
use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class AttachPianolaUserStateMiddleware
{
    public function handle(Request $request, Closure $next): JsonResponse
    {
        $response = $next($request);

        if ($response instanceof JsonResponse) {
            if ($response->exception) {
                return $response;
            }
            $data = $response->getData(true);
            // Get the URL segments
            $segments = $request->segments();
            // Check that we have enough segments
            if (count($segments) >= 4 && $segments[1] === 'pianola') {
                $endpoint = $segments[2];
                $record_id = $segments[3];
                // Attach the Pianola user state data
                $data = $this->attachPianolaUserState($data, $endpoint, $record_id);
            }
            $response = response()->json($data);
        }

        return $response;
    }

    protected function attachPianolaUserState(array $array, string $endpoint, string $recordId)
    {
        $stateData = PianolaUserState::getStateDataForRecord($endpoint, $recordId);

        return array_merge($array, $stateData);
    }
}
