<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaList;
use Illuminate\Http\Request;

class ListController
{
    public function index(Request $request)
    {
        $module = $request->module;

        return PianolaList::where('module', $module)->get();
    }

    public function store(Request $request)
    {
        $record = PianolaList::create([
            'selection' => json_encode($request->input('selection')),
            'name' => $request->input('name'),
            'module' => $request->input('module'),
            'user_id' => auth()->user()->id,
        ]);
        $record['selection'] = json_decode($record['selection']);

        return $record;
    }

    public function update($id, Request $request)
    {
        $record = PianolaList::find($id);
        $record->selection = json_encode($request->input('selection'));
        $record->save();
        $record['selection'] = json_decode($record['selection']);

        return $record;
    }

    public function destroy($id)
    {
        PianolaList::destroy($id);

        return $id;
    }
}
