<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class File extends Model
{
    use HasFactory;

    protected function file_tags()
    {
        return $this->hasMany('App\Models\FileTag');
    }

    public function getUrlAttribute()
    {
        if (env('AWS_BUCKET') == null) {
            return Storage::url($this->path);
        } else {
            return 'https://'.env('AWS_BUCKET').'.s3.'.env('AWS_DEFAULT_REGION').'.amazonaws.com/'.$this->path;
        }
    }
}
