<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shared Data - Dashboard</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
        }

        .navbar {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            padding: 1rem 2rem 1rem 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 1rem;
            font-size: 1.5rem;
            font-weight: bold;
        }

        .navbar-logo {
            height: 40px;
            width: auto;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .user-dropdown {
            position: relative;
            display: inline-block;
            border: 1px solid #999;
            border-radius: 4px;
            padding: 0.375rem 0.5rem;
        }

        .user-name {
            font-weight: 400;
            color: #ddd;
            font-size: 0.85rem;
            cursor: pointer;
            transition: background-color 0.2s;
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        .user-dropdown:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .user-icon {
            width: 16px;
            height: 16px;
            fill: #ddd;
        }

        .dropdown-arrow {
            font-size: 0.6rem;
            margin-left: 0.15rem;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            top: calc(100% + 0.5rem);
            background-color: white;
            border: 1px solid white;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            min-width: 120px;
            z-index: 1000;
        }

        .dropdown-content.show {
            display: block;
        }

        .dropdown-item {
            color: #333;
            padding: 0.75rem 1rem;
            text-decoration: none;
            display: block;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .dropdown-item:hover {
            background-color: #f8f9fa;
        }

        .main-content {
            padding: 2rem;
            max-width: 800px;
            margin: 0 auto;
        }

        .welcome-message {
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-align: center;
        }

        .welcome-message h1 {
            color: #333;
            margin-bottom: 1rem;
        }

        .welcome-message p {
            color: #666;
            font-size: 1.1rem;
        }

        .lists-section {
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-top: 2rem;
        }

        .lists-section h2 {
            color: #333;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
        }

        .lists-table {
            width: 100%;
            max-width: 600px;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        .lists-table th,
        .lists-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        .lists-table th:first-child,
        .lists-table td:first-child {
            width: 70%;
        }

        .lists-table th:last-child,
        .lists-table td:last-child {
            width: 30%;
            text-align: center;
        }

        .lists-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #333;
        }

        .lists-table tr:hover {
            background-color: #f8f9fa;
        }

        .view-btn {
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            text-decoration: none;
            font-size: 0.9rem;
            display: inline-block;
            transition: opacity 0.2s;
        }

        .view-btn:hover {
            opacity: 0.8;
        }

        .no-access-message {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
            color: #856404;
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 1.5rem;
            margin-top: 1rem;
        }

        .warning-icon {
            width: 24px;
            height: 24px;
            fill: #856404;
            flex-shrink: 0;
        }

        .no-access-text {
            font-size: 1rem;
            margin: 0;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            @if($appConfig['logoPath'])
                <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="navbar-logo">
            @endif
            {{ $appConfig['appName'] }} - {{ __('pianola-laravel::shared-data.shared_data') }}
        </div>
        <div class="navbar-user">
            <div class="user-dropdown" onclick="toggleDropdown()">
                <span class="user-name">
                    <svg class="user-icon" viewBox="0 0 24 24">
                        <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                    </svg>
                    {{ Auth::guard('shared_data')->user()->name }}
                    <span class="dropdown-arrow">▼</span>
                </span>
                <div class="dropdown-content" id="userDropdown">
                    <a class="dropdown-item" onclick="logout()">{{ __('pianola-laravel::shared-data.logout') }}</a>
                </div>
            </div>
        </div>
    </nav>

    <main class="main-content">
        @if($lists->count() === 0)
            <div class="welcome-message">
                <h1>{{ __('pianola-laravel::shared-data.welcome', ['name' => $user->name]) }}</h1>

                <div class="no-access-message">
                    <svg class="warning-icon" viewBox="0 0 24 24">
                        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/>
                    </svg>
                    <p class="no-access-text">
                        @if($user->email === 'test@example.com')
                            {{ __('pianola-laravel::shared-data.no_lists_test_user') }}
                        @else
                            {{ __('pianola-laravel::shared-data.no_lists_regular_user') }}
                        @endif
                    </p>
                </div>
            </div>
        @endif

        @if($lists->count() > 0)
            <div class="lists-section">
                <h2>{{ __('pianola-laravel::shared-data.your_lists') }}</h2>

                <table class="lists-table">
                    <thead>
                        <tr>
                            <th>{{ __('pianola-laravel::shared-data.list_name') }}</th>
                            <th>{{ __('pianola-laravel::shared-data.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($lists as $list)
                            <tr>
                                <td>{{ $list->name }}</td>
                                <td>
                                    <a href="{{ route('shared-data.show', $list->id) }}" class="view-btn">{{ __('pianola-laravel::shared-data.view') }}</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </main>

    <script>
        function toggleDropdown() {
            const dropdown = document.getElementById('userDropdown');
            dropdown.classList.toggle('show');
        }

        // Close dropdown when clicking outside
        window.onclick = function(event) {
            if (!event.target.matches('.user-name')) {
                const dropdown = document.getElementById('userDropdown');
                if (dropdown.classList.contains('show')) {
                    dropdown.classList.remove('show');
                }
            }
        }

        async function logout() {
            try {
                const response = await fetch('{{ route("shared-data.logout") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                });

                if (response.ok) {
                    window.location.href = '{{ route("shared-data.login") }}';
                } else {
                    alert('Logout failed. Please try again.');
                }
            } catch (error) {
                alert('An error occurred during logout. Please try again.');
            }
        }
    </script>
</body>
</html>
