<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('pianola-laravel::shared-data.login_button') }} - {{ $appConfig['appName'] }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            @if($appConfig['backgroundPath'])
                background-image: url('{{ $appConfig['backgroundPath'] }}');
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-attachment: fixed;
            @else
                background-color: #f5f5f5;
            @endif
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo {
            height: 60px;
            width: auto;
            margin-bottom: 1rem;
        }

        .app-title {
            color: {{ $appConfig['colorPrimary'] }};
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }

        .login-title {
            color: #333;
            font-size: 1.2rem;
            margin: 0;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
        }

        input[type="email"], input[type="password"] {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
            font-size: 1rem;
            transition: border-color 0.2s;
        }

        input[type="email"]:focus, input[type="password"]:focus {
            outline: none;
            border-color: {{ $appConfig['colorPrimary'] }};
            box-shadow: 0 0 0 2px {{ $appConfig['colorPrimary'] }}20;
        }

        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .remember-me input[type="checkbox"] {
            margin-right: 0.5rem;
            width: auto;
        }

        .remember-me label {
            margin-bottom: 0;
            font-weight: 400;
            font-size: 0.9rem;
            cursor: pointer;
        }

        .login-btn {
            width: 100%;
            padding: 0.75rem;
            background-color: {{ $appConfig['colorPrimary'] }};
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            transition: opacity 0.2s;
        }

        .login-btn:hover {
            opacity: 0.9;
        }

        .login-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .error {
            color: #dc3545;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .success {
            color: #28a745;
            font-size: 0.875rem;
            margin-top: 0.5rem;
            text-align: center;
        }

        .register-link {
            text-align: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid #eee;
        }

        .register-link a {
            color: {{ $appConfig['colorPrimary'] }};
            text-decoration: none;
            font-size: 0.9rem;
        }

        .register-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="header">
            @if($appConfig['logoPath'])
                <img src="{{ $appConfig['logoPath'] }}" alt="{{ $appConfig['appName'] }}" class="logo">
            @endif
            <div class="app-title">{{ $appConfig['appName'] }}</div>
            <h2 class="login-title">{{ __('pianola-laravel::shared-data.login_title') }}</h2>
        </div>

        <form id="loginForm">
            <div class="form-group">
                <label for="email">{{ __('pianola-laravel::shared-data.email') }}:</label>
                <input type="email" id="email" name="email" required>
                <div class="error" id="email-error"></div>
            </div>

            <div class="form-group">
                <label for="password">{{ __('pianola-laravel::shared-data.password') }}:</label>
                <input type="password" id="password" name="password" required>
                <div class="error" id="password-error"></div>
            </div>

            <div class="remember-me">
                <input type="checkbox" id="remember" name="remember">
                <label for="remember">{{ __('pianola-laravel::shared-data.remember_me') }}</label>
            </div>

            <button type="submit" class="login-btn">{{ __('pianola-laravel::shared-data.login_button') }}</button>
            <div class="success" id="success-message"></div>
            <div class="error" id="general-error"></div>
        </form>

        <div class="register-link">
            <a href="{{ route('shared-data.register') }}">{{ __('pianola-laravel::shared-data.no_account') }}</a>
        </div>
    </div>

    <script>
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Clear previous errors
            document.querySelectorAll('.error').forEach(el => el.textContent = '');
            document.getElementById('success-message').textContent = '';
            
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);
            
            try {
                const response = await fetch('{{ route("shared-data.login.post") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    document.getElementById('success-message').textContent = '{{ __("pianola-laravel::shared-data.login_successful") }}';
                    setTimeout(() => {
                        window.location.href = '{{ route("shared-data.index") }}';
                    }, 1000);
                } else {
                    if (result.errors) {
                        Object.keys(result.errors).forEach(field => {
                            const errorEl = document.getElementById(field + '-error');
                            if (errorEl) {
                                errorEl.textContent = result.errors[field][0];
                            }
                        });
                    } else {
                        document.getElementById('general-error').textContent = result.message || '{{ __("pianola-laravel::shared-data.login_failed") }}';
                    }
                }
            } catch (error) {
                document.getElementById('general-error').textContent = '{{ __("pianola-laravel::shared-data.error_occurred") }}';
            }
        });
    </script>
</body>
</html>
