<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\DocumentMakerService;
use Illuminate\Http\Request;
use Str;

class DocumentMakerController
{
    public function createForSingleRecord($endpoint, $record_id, Request $request)
    {
        $pianolaController = new RecordsController;
        $pianolaDocumentMakerService = new DocumentMakerService;
        $template_id = $request->input('template_id');
        $data = $pianolaController->show($endpoint, $record_id)->toArray();
        $storage_path = '/tmp/'.Str::uuid().'.docx';

        return $pianolaDocumentMakerService->processDocumentCreation($template_id, $data, null, null, $storage_path);
    }

    public function createForMultipleRecords($endpoint, Request $request)
    {
        $pianolaController = new RecordsController;
        $pianolaDocumentMakerService = new DocumentMakerService;
        $template_id = $request->input('template_id');
        $data[$endpoint] = $pianolaController->index($endpoint, $request)->toArray();
        $storage_path = '/tmp/'.Str::uuid().'.docx';

        return $pianolaDocumentMakerService->processDocumentCreation($template_id, $data, null, null, $storage_path);
    }
}
