<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Database\Eloquent\Model;

class SharedDataList extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'pianola_shared_data_lists';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'base_table',
        'pianola_list_id',
        'pianola_query_id',
        'user_id',
        'expiration_date',
        'filter_field',
        'filter_value',
    ];

    /**
     * Get the user that owns this shared data list.
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    /**
     * Get the members for this shared data list.
     */
    public function members()
    {
        return $this->hasMany(SharedDataListMember::class, 'pianola_shared_data_list_id');
    }

    /**
     * Get the pianola list (if exists).
     */
    public function pianolaList()
    {
        return $this->belongsTo(PianolaList::class, 'pianola_list_id');
    }

    /**
     * Get the pianola query (if exists).
     */
    public function pianolaQuery()
    {
        return $this->belongsTo(PianolaQuery::class, 'pianola_query_id');
    }

    /**
     * Get the members' emails as a comma-separated string.
     */
    public function getMembersCommaSeparatedAttribute()
    {
        return $this->members->pluck('email')->implode(', ');
    }
}
