<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\AlertController;
use BalletMecanique\PianolaLaravel\Http\Controllers\ConfigController;
use BalletMecanique\PianolaLaravel\Http\Controllers\FieldsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\ListController;
use BalletMecanique\PianolaLaravel\Http\Controllers\QueryController;
use BalletMecanique\PianolaLaravel\Http\Controllers\RecordsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

// Config
Route::get('pianola-config', [ConfigController::class, 'getAppConfig']);

// User Routes
Route::post('change-password', [UserController::class, 'changePassword']);
Route::get('/user', [UserController::class, 'returnUser']);
Route::apiResource('users', UserController::class);

// Queries
Route::apiResource('queries', QueryController::class);

//Excel Exports
Route::apiResource('excel-exports', ExcelExportController::class);

//Lists
Route::apiResource('lists', ListController::class);

//Fields
Route::get('fields/{endpoint}', [FieldsController::class, 'show']);

//Alerts
Route::get('/alerts/{endpoint}/{record_id}', [AlertController::class, 'index']);
Route::patch('/alerts/{record_id}', [AlertController::class, 'update']);
Route::post('/alerts', [AlertController::class, 'store']);


 // Records Controller
Route::get('/count/{endpoint}', [RecordsController::class, 'count']);
Route::get('/global', [RecordsController::class, 'global']);
Route::get('{endpoint}', [RecordsController::class, 'index']);
Route::get('{endpoint}/{record_id}', [RecordsController::class, 'show']);
Route::post('{endpoint}', [RecordsController::class, 'store']);
Route::patch('{endpoint}/{record_id}', [RecordsController::class, 'update']);
Route::delete('{endpoint}/{record_id}', [RecordsController::class, 'destroy']);
