<?php

namespace BalletMecanique\PianolaLaravel\Commands;

use BalletMecanique\PianolaLaravel\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class CreateDevUserCommand extends Command
{
    public $signature = 'pianola:create-dev-user';

    public $description = 'Creates a Dev User';

    public function handle(): int
    {
        //create new user with feedback
        $this->info('Create a local dev user for the app:');
        $name = $this->ask('What is your name?');
        while ($name == '') {
            $name = $this->ask('Name cannot be empty. What is your name?');
        }
        $email = $this->ask('What is your mail address?');
        while ($email == '') {
            $email = $this->ask('Email address cannot be empty. What is your mail address?');
        }
        $password = $this->ask('What initial password do you want to use?', 'password');

        User::create([
            'name' => $name,
            'email' => $email,
            'password' => Hash::make($password),
            'is_dev' => 1,
            'is_admin' => 1,
            'is_active' => 1,
            'modules' => json_encode([]),
        ]);

        return self::SUCCESS;
    }
}
