<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_shared_data_lists', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('base_table')->index();
            $table->string('name')->index();
            $table->foreignId('pianola_list_id')
                ->nullable()
                ->constrained('pianola_lists')
                ->onDelete('cascade')
                ->name('fk_shared_data_lists_list_id');
            $table->foreignId('pianola_query_id')
                ->nullable()
                ->constrained('pianola_queries')
                ->onDelete('cascade')
                ->name('fk_shared_data_lists_query_id');
            $table->date('expiration_date')->nullable();
            $table->string('filter_field')->nullable();
            $table->string('filter_value')->nullable();
            $table->timestamps();
        });
    }
};
