<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\SharedDataAuthController;
use BalletMecanique\PianolaLaravel\Http\Controllers\SharedDataController;
use BalletMecanique\PianolaLaravel\Http\Middleware\SharedDataAuthMiddleware;
use Illuminate\Support\Facades\Route;

// Authentication routes (no middleware required)
Route::group(['prefix' => 'auth'], function () {
    // Registration routes
    Route::get('register', [SharedDataAuthController::class, 'showRegistrationForm'])->name('shared-data.register');
    Route::post('register', [SharedDataAuthController::class, 'register'])->name('shared-data.register.post');

    // Login routes
    Route::get('login', [SharedDataAuthController::class, 'showLoginForm'])->name('shared-data.login');
    Route::post('login', [SharedDataAuthController::class, 'login'])->name('shared-data.login.post');

    // Logout route
    Route::post('logout', [SharedDataAuthController::class, 'logout'])->name('shared-data.logout');

    // Current user route
    Route::get('user', [SharedDataAuthController::class, 'user'])->name('shared-data.user');
});
// Protected routes (require authentication or unlock token)
Route::middleware([SharedDataAuthMiddleware::class])->group(function () {
    // Data routes
    Route::get('/', [SharedDataController::class, 'index'])->name('shared-data.index');
    Route::get('/{id}', [SharedDataController::class, 'show'])->name('shared-data.show');
});

// Utility routes (for generating unlock tokens - you might want to protect these differently)
Route::post('generate-unlock-token', [SharedDataController::class, 'generateUnlockToken'])->name('shared-data.generate-token');
