<?php

namespace BalletMecanique\PianolaLaravel\Models;

use Illuminate\Database\Eloquent\Model;

class SharedDataList extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'pianola_shared_data_lists';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'base_table',
        'pianola_list_id',
        'pianola_query_id',
    ];

    /**
     * Get the members for this shared data list.
     */
    public function members()
    {
        return $this->hasMany(SharedDataListMember::class, 'pianola_shared_data_list_id');
    }

    /**
     * Get the pianola list (if exists).
     */
    public function pianolaList()
    {
        return $this->belongsTo(PianolaList::class, 'pianola_list_id');
    }

    /**
     * Get the pianola query (if exists).
     */
    public function pianolaQuery()
    {
        return $this->belongsTo(PianolaQuery::class, 'pianola_query_id');
    }
}
