<?php

namespace BalletMecanique\PianolaLaravel;

use BalletMecanique\PianolaLaravel\Commands\CreateModelsCommand;
use BalletMecanique\PianolaLaravel\Commands\PianolaInstallCommand;
use BalletMecanique\PianolaLaravel\Commands\UpdateSchemaCommand;
use BalletMecanique\PianolaLaravel\Http\Controllers\ConfigController;
use Illuminate\Support\Facades\Route;
use Laravel\Fortify\Http\Controllers\AuthenticatedSessionController;
use Laravel\Fortify\Http\Controllers\TwoFactorAuthenticatedSessionController;
use Laravel\Fortify\Http\Controllers\TwoFactorAuthenticationController;
use Laravel\Fortify\Http\Controllers\TwoFactorQrCodeController;
use Laravel\Sanctum\Http\Controllers\CsrfCookieController;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class PianolaLaravelServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('pianola-laravel')
            ->hasConfigFile()
            ->hasViews()
            ->hasMigrations([
                'create_countries_table',
                'create_people_table',
                'create_companies_table',
                'create_employees_table',
                ])
            ->hasCommand(PianolaInstallCommand::class)
            ->hasCommand(CreateModelsCommand::class)
            ->hasCommand(UpdateSchemaCommand::class);
    }

    public function packageRegistered()
    {
        //api routes
        Route::get('api/pianola/login-config', [ConfigController::class, 'getLoginConfig']);
        //TO DO: remove these when front-end app is adjusted
        Route::group(['middleware' => 'web'], function () {
            Route::post('api/login', [AuthenticatedSessionController::class, 'store']);
            Route::get('api/sanctum/csrf-cookie', CsrfCookieController::class.'@show');
            //2FA Routes
            Route::post('api/user/two-factor-authentication', [TwoFactorAuthenticationController::class, 'store']);
            Route::get('api/user/two-factor-qr-code', [TwoFactorQrCodeController::class, 'show']);
            Route::post('api/two-factor-challenge', [TwoFactorAuthenticatedSessionController::class, 'store']);
        });
        //EOTODO

        Route::group($this->apiRouteConfigurationInterceptedRoutes(), function () {
            $this->loadRoutesFrom(base_path('/routes/pianola.php'));
        });
        Route::group($this->apiRouteConfiguration(), function () {
            $this->loadRoutesFrom(__DIR__.'/../routes/api.php');
        });
        //web routes
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');
        //load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../database/package_migrations');
    }

    protected function apiRouteConfiguration()
    {
        return [
            'prefix' => 'api/pianola',
            'middleware' => ['web','auth:sanctum'],
        ];
    }

    protected function apiRouteConfigurationInterceptedRoutes()
    {
        return [
            'prefix' => 'api/pianola',
            'middleware' => ['web','auth:sanctum'],
            'namespace' => 'App\\Http\\Controllers',
        ];
    }
}
