<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\AlertController;
use BalletMecanique\PianolaLaravel\Http\Controllers\CalendarPresetController;
use BalletMecanique\PianolaLaravel\Http\Controllers\GlobalFilterController;
use BalletMecanique\PianolaLaravel\Http\Controllers\ConfigController;
use BalletMecanique\PianolaLaravel\Http\Controllers\FieldsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\FileUploadController;
use BalletMecanique\PianolaLaravel\Http\Controllers\ExcelExportController;
use BalletMecanique\PianolaLaravel\Http\Controllers\GlobalSearchController;
use BalletMecanique\PianolaLaravel\Http\Controllers\ListController;
use BalletMecanique\PianolaLaravel\Http\Controllers\QueryController;
use BalletMecanique\PianolaLaravel\Http\Controllers\RecordsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

// Config
Route::get('pianola-config', [ConfigController::class, 'getAppConfig']);
Route::post('pianola-config', [ConfigController::class, 'storeAppConfig']);
Route::get('pianola-dev-mode', [ConfigController::class, 'getDevMode']);
Route::get('pianola-schema', [ConfigController::class, 'getSchemaConfig']);
Route::post('pianola-schema', [ConfigController::class, 'storeSchemaConfig']);
Route::get('update-schema', [ConfigController::class, 'updateSchema']);
Route::get('create-models', [ConfigController::class, 'createModels']);

// User Routes
Route::post('change-password', [UserController::class, 'changePassword']);
Route::get('/user', [UserController::class, 'returnUser']);
Route::apiResource('users', UserController::class);
Route::patch('users/{id}/reset-password', [UserController::class, 'resetPassword']);
Route::patch('users/{id}/reset-2fa', [UserController::class, 'reset2fa']);

// Queries
Route::apiResource('queries', QueryController::class);

//Excel Exports
Route::apiResource('excel-exports', ExcelExportController::class);

//Lists
Route::apiResource('lists', ListController::class);

//Calendar Presets
Route::apiResource('calendar_presets', CalendarPresetController::class);

//Fields
Route::get('fields/{endpoint}', [FieldsController::class, 'show']);

//Alerts
Route::get('/alerts/{endpoint}/{record_id}', [AlertController::class, 'index']);
Route::patch('/alerts/{record_id}', [AlertController::class, 'update']);
Route::post('/alerts', [AlertController::class, 'store']);

//Global Filters
Route::get('global-filter/{endpoint}/{valueField}/{labelField}', [GlobalFilterController::class, 'show']);

// Records Controller
Route::get('/count/{endpoint}', [RecordsController::class, 'count']);
Route::get('/global', [GlobalSearchController::class, 'index']);
Route::get('{endpoint}', [RecordsController::class, 'index']);
Route::get('{endpoint}/{record_id}', [RecordsController::class, 'show']);
Route::post('{endpoint}', [RecordsController::class, 'store']);
Route::patch('{endpoint}/{record_id}', [RecordsController::class, 'update']);
Route::delete('{endpoint}/{record_id}', [RecordsController::class, 'destroy']);
