<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

// use App\Mail\AlertMail;
use BalletMecanique\PianolaLaravel\Models\PianolaAlert;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class AlertController
{
    public function index($endpoint, $record_id)
    {
        $user_id = Auth::user()->id;
        $alerts = PianolaAlert::where('user_id', $user_id)
                ->where('endpoint', $endpoint)
                ->where('record_id', $record_id)
                ->whereDate('date', '>=', Carbon::now())
                ->get();

        return $alerts;
    }

    public function update($id, Request $request)
    {
        $record = PianolaAlert::find($id);
        $input = $request->input();
        if ($record->exists()) {
            $record->update($input);

            return $this->index($input['endpoint'], $input['record_id']);
        } else {
            return response('record does not exist', 404);
        }
    }

    public function store(Request $request)
    {
        $model = new PianolaAlert();
        $input = $request->input();
        $input['user_id'] = Auth::user()->id;
        $model->fill($input);
        $model->save();

        return $this->index($input['endpoint'], $input['record_id']);
    }

    // public function sendAlert()
    // {
    //     $alerts = PianolaAlert::whereDate('date', '=', date('Y-m-d'))->with('user')->get();

    //     if ($alerts->count() > 0) {
    //         foreach ($alerts as $alert) {
    //             $mail = Mail::to($alert->user->email);
    //             if (env('ALERT_BCC')) {
    //                 $mail->bcc(env('ALERT_BCC'));
    //             }
    //             $mail->send(new AlertMail($alert));
    //         }
    //     }
    // }
}
