<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_cms_content_nodes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_cms_project_id')->nullable()->constrained('pianola_cms_projects');
            $table->foreignId('pianola_cms_content_node_id')->nullable()->constrained('pianola_cms_content_nodes')->cascadeOnDelete();
            $table->boolean('has_subnodes')->nullable();
            $table->boolean('has_introductory_content_blocks')->nullable();
            $table->string('title_en')->nullable();
            $table->string('title_de')->nullable();
            $table->string('show_if')->nullable();
            $table->integer('sort_order')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_cms_content_nodes');
    }
};
