<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\CalendarPrintoutController;
use BalletMecanique\PianolaLaravel\Http\Controllers\CmsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\FormController;
use BalletMecanique\PianolaLaravel\Http\Controllers\HomeController;
use BalletMecanique\PianolaLaravel\Http\Middleware\CmsMiddleware;
use Illuminate\Support\Facades\Route;

Route::macro('pianola', function () {

    //forms
    $formsSubdomain = config('app.forms_subdomain') ?? 'forms';
    Route::domain($formsSubdomain.'.'.config('app.domain'))->group(function () {
        Route::get('/api/form-styling', [FormController::class, 'getStyling']);
        Route::get('/api/form-basics/{slug}', [FormController::class, 'getFormBasics']);
        Route::get('/api/form-elements/{slug}', [FormController::class, 'getFormElements']);
        Route::get('/api/form-data/{submissionId}', [FormController::class, 'getFormData']);
        Route::get('/api/form-data', fn () => null);
        Route::post('/api/form-submissions', [FormController::class, 'store']);
        Route::get('/{slug}/{id?}', [FormController::class, 'create']);
        Route::get('/', fn () => null);
    });

    //public cms
    $cmsSubdomain = config('app.cms_subdomain') ?? 'guides';
    Route::domain($cmsSubdomain.'.'.config('app.domain'))->middleware(CmsMiddleware::class)->group(function () {
        Route::get('/{cmsProject}/', [CmsController::class, 'show']);
        Route::get('/api/pianola-guides/{cmsProject}', [CmsController::class, 'api']);
        Route::get('/', fn () => null);
    });

    Route::middleware('auth')->group(function () {
        //internal cms
        Route::get('/guides/{cmsProject}', [CmsController::class, 'show']);
        Route::get('/guides/api/pianola-guides/{cmsProject}', [CmsController::class, 'api']);
        //calendar printout
        Route::get('/calendar-printout/{endpoint}', CalendarPrintoutController::class);
    });

    Route::get('/', [HomeController::class, 'show']);
    Route::get('/login', [HomeController::class, 'show']);

    Route::get('/{any}', [HomeController::class, 'show'])->where('any', '.*');

});
