<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaCmsProject;

class CmsController
{
    public function show($projectSlug)
    {
        $project = PianolaCmsProject::where('slug', $projectSlug)->firstOrFail();

        /*
         - [ ] checks which frontend version has been selected
         - [ ] returns a view which loads the needed frontend
         */
        return $project;
    }

    public function api($projectSlug)
    {
        $project = PianolaCmsProject::where('slug', $projectSlug)->firstOrFail()->load('nodes');
        /*
            - [ ] returns the data for the cms
         */
        $project->styling = $this->getStyling();

        return $project;
    }

    protected function getStyling(): array
    {
        $appJson = file_get_contents(config_path('pianola/app.json'));
        $app = json_decode($appJson, true, 512, JSON_THROW_ON_ERROR);

        return collect($app['basicConfig'])
            ->only('appLanguage', 'appName', 'appFont', 'logoPath', 'colorBackground', 'colorPrimary', 'bannerPath')
            ->toArray();
    }
}
