<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\RelationshipBuilder;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class FieldsController
{
    protected $schema;

    public function __construct()
    {
        $this->schema = json_decode(File::get(config_path('/pianola/schema.json')), true);
    }

    public function show($endpoint)
    {
        $fields = $this->returnAllFields($endpoint, $endpoint);
        $sortedFields = collect($fields)
            ->map(function ($field) {
                return [
                    'label' => trim($field['label']),
                    'value' => $field['name'],
                    'merge_name' => '${'.$field['name'].'}',
                ];
            })
            ->sortBy(function ($item) {
                return $item['label'];
            })
            ->values()
            ->all();
        usort($sortedFields, function ($a, $b) {
            return strnatcasecmp($a['label'], $b['label']);
        });
        $result['basisFields'] = $sortedFields;
        $relatedHasManyTables = $this->getRelatedTables($endpoint, 'hasMany');
        // return $relatedHasManyTables;
        foreach ($relatedHasManyTables as $relatedTableName => $emptyArray) {
            $relatedFields = $this->returnAllFields($relatedTableName, $endpoint);
            $result['relatedFields'][$relatedTableName] = collect($relatedFields)->map(function ($field) {
                return [
                    'label' => $field['label'],
                    'value' => $field['name'],
                    'merge_name' => '${'.$field['name'].'}',
                ];
            });
        }
        //return schema info
        foreach ($relatedHasManyTables as $relatedTableName => $emptyArray) {
            $tableSchema = collect($this->schema)->where('name', $relatedTableName)->first();
            $result['relatedTableNames'][$relatedTableName] = $tableSchema['app_name_plural'] ?? $tableSchema['app_name_singular'] ?? $relatedTableName;
        }

        return $result;
    }

    public function returnAllFields($endpoint, $originEndpoint)
    {
        //attributes are database columns
        $tableSchema = collect($this->schema)->where('name', $endpoint)->first();
        $columns = collect($tableSchema['columns'] ?? [])->map(function ($field) {
            if ($field['app_label']) {
                return [
                    'name' => $field['name'],
                    'label' => trim($field['app_label'] ?? 'Ω '.$field['name']),
                ];
            }
        })->filter()->all();
        $attributes = $columns;

        // return $this->getAppendArray($endpoint);
        //attributes are also custom attributes
        if ($this->getAppendArray($endpoint)) {
            $attributes = array_merge($attributes, $this->getAppendArray($endpoint));
        }
        $fields = [];
        foreach ($attributes as $attribute) {
            $fieldName = $attribute['name'];
            if (
                //!is_array($value) and //what is this for?
                $fieldName != 'id'
                and
                ! $this->endsWith($fieldName, '_id')
                and
                $fieldName != 'created_at'
                and
                $fieldName != 'updated_at'
            ) {
                $fields[] = $attribute;
            }
        }
        $belongsToTables = $this->getRelatedTables($endpoint, 'belongsTo');
        foreach ($belongsToTables as $belongsToTable => $value) {
            $relationships = new RelationshipBuilder($endpoint, null);
            $singularTableName = $this->singularize($belongsToTable);
            $tableSchema = collect($this->schema)->where('name', $belongsToTable)->first();
            $labelName = $tableSchema['app_name_singular'] ?? null;
            $ok = ! in_array($singularTableName, $relationships->getOmittedFromExcelBelongsToTables()->toArray());
            if ($ok) {
                $belongsToFields = $this->returnAllFields($belongsToTable, $endpoint);
                $relatedFields = collect($belongsToFields)->map(function ($field) use ($singularTableName, $labelName) {
                    return [
                        'name' => $singularTableName.'.'.$field['name'],
                        'label' => trim($labelName.' '.$field['label']),
                    ];
                })->all();
                if ($belongsToTable != $originEndpoint) {
                    $fields = array_merge($fields, $relatedFields);
                }
            }
        }
        $extraHasManyFieldsTables = $this->getRelatedTables($endpoint, 'loadExtraHasManyFields');
        foreach ($extraHasManyFieldsTables as $extraHasManyFieldsTable => $value) {
            $tableSchema = collect($this->schema)->where('name', $extraHasManyFieldsTable)->first();
            $relatedFields = collect($tableSchema['columns'] ?? [])->map(function ($field) use ($extraHasManyFieldsTable) {
                if ($field['app_label']) {
                    return [
                        'name' => $extraHasManyFieldsTable.'.0.'.$field['name'],
                        'label' => $field['app_label'],
                    ];
                }
            })->filter()->all();
            if ($extraHasManyFieldsTable != $originEndpoint) {
                $fields = array_merge($fields, $relatedFields);
            }
        }

        return collect($fields)->sortBy('label')->all();
    }

    protected function getRelatedTables($table, $relationshipType)
    {
        $table_names = collect(collect($this->schema)->where('name', $table)->pluck($relationshipType)->first())->pluck('name');
        $array = [];
        foreach ($table_names as $table_name) {
            if ($table_name !== $table) {
                $array[$table_name] = [];
            }
        }

        return $array;
    }

    public function getAppendArray($endpoint)
    {
        //change this
        $tableSchema = collect($this->schema)->where('name', $endpoint)->first();

        if (isset($tableSchema['custom_attributes'])) {
            return collect($tableSchema['custom_attributes'])->map(function ($customAttribute) {
                if ($customAttribute['app_label']) {
                    return [
                        'name' => $customAttribute['name'],
                        'label' => $customAttribute['app_label'],
                    ];
                }
            })->filter()->all();
        }
    }

    protected function singularize($endpoint)
    {
        return Str::lower(Str::singular($endpoint));
    }

    protected function endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if (! $length) {
            return true;
        }

        return substr($haystack, -$length) === $needle;
    }
}
