<?php

namespace BalletMecanique\PianolaLaravel\Http\Middleware;

use BalletMecanique\PianolaLaravel\Models\PianolaCmsProject;

class CmsMiddleware
{
    public function handle($request, $next)
    {
        //get the project slug from the request
        $projectSlug = $request->route('cmsProject');
        $cmsProject = PianolaCmsProject::query()
            ->where('slug', $projectSlug)
            ->where(function ($query) {
                $query->where('is_auth_only', false)
                    ->orWhereNull('is_auth_only');
            })
            ->first();
        if (! $cmsProject) {
            abort(404);
        }

        return $next($request);
    }
}
