<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pianola_cms_content_elements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pianola_cms_content_node_id')->nullable()->constrained('pianola_cms_content_nodes')->cascadeOnDelete();
            $table->string('type')->nullable();
            $table->text('text_de')->nullable();
            $table->text('text_en')->nullable();
            $table->integer('table_number_of_columns')->nullable();
            $table->boolean('table_display_grid')->nullable();
            $table->boolean('table_display_column_titles')->nullable();
            $table->string('table_column_title_1_de')->nullable();
            $table->string('table_column_title_1_en')->nullable();
            $table->string('table_column_title_2_de')->nullable();
            $table->string('table_column_title_2_en')->nullable();
            $table->string('table_column_title_3_de')->nullable();
            $table->string('table_column_title_3_en')->nullable();
            $table->string('show_if')->nullable();
            $table->integer('sort_order')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pianola_cms_content_elements');
    }
};
