<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\QueryBuilder;
use BalletMecanique\PianolaLaravel\Services\RelationshipBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RecordsController
{
    public function count($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        $model = new $modelName();
        $records = new QueryBuilder($model, $request);

        return $records->count();
    }

    public function index($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        // return $modelName;
        $model = new $modelName();
        $records = new QueryBuilder($model, $request);
        $relationships = new RelationshipBuilder($endpoint, null);
        $records = $records->get();
        if ($request->input('load') === 'true') {
            $records->load($relationships->getLoadArray());
        }

        return $records;
    }

    public function show($endpoint, $id)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        $model = $modelName::find($id);
        $relationships = new RelationshipBuilder($endpoint, null);
        $model->load($relationships->getLoadArray());

        return $model;
    }

    public function store($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $model = new $modelName();
        $model->fill($request->input('data'));
        $model->save();
        if ($request->input('load')) {
            $relationships = new RelationshipBuilder($endpoint, null);
            $model->load($relationships->getLoadArray());

            return $model;
        } else {
            return 'ok';
        }
    }

    public function update($endpoint, $id, Request $request)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $record = $modelName::find($id);
        if ($record->exists()) {
            $record->update($request->input('data'));
            if ($request->input('load')) {
                $relationships = new RelationshipBuilder($endpoint, null);
                $record->load($relationships->getLoadArray());

                return $record;
            } else {
                return 'ok';
            }
        } else {
            return response('record does not exist', 404);
        }
    }

    public function destroy($endpoint, $id)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $modelName::destroy($id);

        return $id;
    }
}
