<?php

use BalletMecanique\PianolaLaravel\Http\Controllers\FieldsController;
use BalletMecanique\PianolaLaravel\Http\Controllers\GlobalFilterController;
use BalletMecanique\PianolaLaravel\Http\Controllers\RecordsController;
use BalletMecanique\PianolaLaravel\Http\Middleware\AttachPianolaUserStateMiddleware;
use BalletMecanique\PianolaLaravel\Http\Middleware\RemoveNestedArraysMiddleware;
use Illuminate\Support\Facades\Route;

//Global Filters
Route::get('global-filter/{endpoint}/{valueField}/{labelField}', [GlobalFilterController::class, 'show']);

// Records Controller
Route::get('/count/{endpoint}', [RecordsController::class, 'count']);
Route::get('{endpoint}', [RecordsController::class, 'index'])->middleware(RemoveNestedArraysMiddleware::class);
Route::get('{endpoint}/{record_id}', [RecordsController::class, 'show'])->middleware(RemoveNestedArraysMiddleware::class)->middleware(AttachPianolaUserStateMiddleware::class);
Route::post('{endpoint}', [RecordsController::class, 'store']);
Route::patch('{endpoint}/{record_id}', [RecordsController::class, 'update']);
Route::delete('{endpoint}/{record_id}', [RecordsController::class, 'destroy']);

//Fields
Route::get('fields/{endpoint}', [FieldsController::class, 'show']);
