<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\QueryBuilder;
use BalletMecanique\PianolaLaravel\Services\RightsChecker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class GlobalSearchController
{
    public function index(Request $request)
    {
        $configModules = collect($this->appConfigArray()['modules']);
        $appConfig = collect($this->appConfigArray()['basicConfig']);

        $globals_array = $configModules->map(function ($module) use ($appConfig) {
            return [
                'module_name' => $module['basicConfig']['name'] ?? null,
                'path' => $module['basicConfig']['path'] ?? null,
                'endpoint' => $module['basicConfig']['apiEndpoint'] ?? null,
                'description_column' => $module['recordTitleConfig'] ? $module['recordTitleConfig']['fieldTitle'] : null ,
                'icon' => $module['basicConfig']['iconRecord'] ?? $module['basicConfig']['icon'] ?? null,
                'color' => $appConfig['colorPrimary'] ?? null,
            ];
        });

        $array = [];

        foreach ($globals_array as $module) {
            if (! $this->filterColumnsAreDefined($module['endpoint'])) {
                continue;
            }
            if ($this->checkRights($module['endpoint']) == 'none') {
                continue;
            }
            $modelName = 'App\\Models\\'.Str::singular(Str::studly($module['endpoint']));
            $model = new $modelName();
            $records = new QueryBuilder($model, $request);
            $records = $records->get();
            foreach ($records as $record) {
                $subarray = [];
                $subarray['id'] = $record['id'];
                $subarray['name'] = $record[$module['description_column']];
                $subarray['path'] = $module['path'];
                $subarray['color'] = $module['color'] ?? null;
                $subarray['icon'] = $module['icon'] ?? null;
                $subarray['endpoint'] = $module['module_name'];
                $array[] = $subarray;
            }
        }

        $array = collect($array)->sortBy('name')->values()->all();

        return $array;
    }

    protected function filterColumnsAreDefined($endpoint)
    {
        return collect($this->schemaConfigArray())->where('name', $endpoint)->first()['app_record_filter_columns'] ?? null;
    }

    protected function checkRights($endpoint)
    {
        $checker = new RightsChecker();

        return $checker->checkEndpointRights($endpoint);
    }

    protected function appConfigArray()
    {
        return json_decode(
            File::get(config_path('/pianola/app.json')),
            true
        );
    }

    protected function schemaConfigArray()
    {
        return json_decode(
            File::get(config_path('/pianola/schema.json')),
            true
        );
    }
}
