<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Services\QueryBuilder;
use BalletMecanique\PianolaLaravel\Services\RelationshipBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class RecordsController
{
    public function count($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        $model = new $modelName();
        $records = new QueryBuilder($model, $request);

        return $records->count();
    }

    public function index($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        // return $modelName;
        $model = new $modelName();
        $records = new QueryBuilder($model, $request);
        $relationships = new RelationshipBuilder($endpoint, null);
        $records = $records->get();
        if ($request->input('load') === 'true') {
            $this->resolveRelationships($relationships, $endpoint);
            $records->load($relationships->getLoadArray());
        }

        return $records;
    }

    public function show($endpoint, $id)
    {
        $modelName = 'App\\Models\\' . Str::singular(Str::studly($endpoint));
        $model = $modelName::find($id);
        $relationships = new RelationshipBuilder($endpoint, null);

        $this->resolveRelationships($relationships, $endpoint);
        $model->load($relationships->getLoadArray() ?? []);

        return $model;
    }

    public function store($endpoint, Request $request)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $model = new $modelName();
        $maxId = $model::max('id');
        $model->fill($request->input('data'));
        $model->id = $maxId + 1;
        $model->save();
        if ($request->input('load')) {
            $relationships = new RelationshipBuilder($endpoint, null);
            $this->resolveRelationships($relationships, $endpoint);
            $model->load($relationships->getLoadArray());

            return $model;
        } else {
            return 'ok';
        }
    }

    public function update($endpoint, $id, Request $request)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $record = $modelName::find($id);
        if ($record->exists()) {
            $record->update($request->input('data'));
            if ($request->input('load')) {
                $relationships = new RelationshipBuilder($endpoint, null);
                $record->load($relationships->getLoadArray());

                return $record;
            } else {
                return 'ok';
            }
        } else {
            return response('record does not exist', 404);
        }
    }

    public function destroy($endpoint, $id)
    {
        $modelName = 'App\\Models\\'.Str::singular(Str::studly($endpoint));
        $modelName::destroy($id);

        return $id;
    }

    protected function resolveRelationships($relationships, $endpoint)
    {
        foreach ($relationships->getLoadArray() as $relationship) {
            $pathArray = explode('.', $endpoint . '.'. $relationship);
            foreach ($pathArray as $key => $origin) {
                if ($key !== array_key_last($pathArray)) {
                    $originModelName = 'App\\Models\\' . Str::singular(Str::studly($origin));
                    $relationship = $pathArray[$key + 1];
                    $originModelName::resolveRelationUsing($relationship, function ($originModel) use ($relationship, $origin) {
                        $modelName = $this->checkIfModelName(Str::studly($relationship)) ? Str::studly($relationship) : Str::singular(Str::studly($relationship));
                        $relatedModel = 'App\\Models\\' . $modelName;
                        if (Str::singular($relationship) == $relationship || $this->checkIfModelName($relationship)) {
                            return $originModel->belongsTo($relatedModel, $relationship . '_id');
                        } else {
                            $resolvedRelationship = $originModel->hasMany($relatedModel);
                            if ($sortRules = $this->getSortRules($origin, $relationship)) {
                                foreach ($sortRules as $sortRule) {
                                    $resolvedRelationship = $resolvedRelationship->orderBy($sortRule['field'], $sortRule['sortOrder'] ?? "asc");
                                }
                            }

                            return $resolvedRelationship;
                        }
                    });
                }
            }
        }
    }

    protected function getSortRules($origin, $relationship)
    {
        $schema = collect(json_decode(File::get(config_path('/pianola/schema.json')), true));
        $tableSchema = collect($schema->where('name', $origin)->first());

        return
        collect($tableSchema['hasMany'] ?? [])->where('name', $relationship)->first()['sortOrder']
        ??
        collect($tableSchema['belongsTo'] ?? [])->where('name', $relationship)->first()['sortOrder']
        ??
        null;
    }

    protected function checkIfModelName($relationship)
    {
        $schema = collect(json_decode(File::get(config_path('/pianola/schema.json')), true));

        return $schema->where('modelName', Str::title($relationship))->count() > 0;
    }
}
