<?php

namespace BalletMecanique\PianolaLaravel\Http\Controllers;

use BalletMecanique\PianolaLaravel\Models\PianolaQuery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QueryController
{
    public function index(Request $request)
    {
        $base_table = $request->input('base_table');
        $queries = PianolaQuery::where('base_table', $base_table)->get();

        return $queries;
    }

    public function store(Request $request)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;
        $query = PianolaQuery::create($input);

        return $query;
    }

    public function show($id)
    {
        $query = PianolaQuery::find($id);

        return $query;
    }

    public function update(Request $request, $id)
    {
        $input = $request->all();
        $input['user_id'] = Auth::user()->id;
        $query = PianolaQuery::find($id);
        $query->update($input);

        return $query;
    }

    public function destroy($id)
    {
        $query = PianolaQuery::destroy($id);

        return 'ok';
    }
}
